/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.gui.slot;

import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public abstract class CustomSlot
implements Slot {
    private Slot delegate = null;

    protected CustomSlot() {
    }

    protected void init(@NotNull Slot slot) {
        this.delegate = slot;
    }

    @Override
    @NotNull
    public final ItemStack getItemStack(@NotNull Player player) {
        if (this.delegate == null) {
            throw new IllegalStateException("Custom Slot was not initialized!");
        }
        return this.delegate.getItemStack(player);
    }

    @Override
    public final boolean isCaptive(@NotNull Player player, @NotNull Menu menu) {
        if (this.delegate == null) {
            throw new IllegalStateException("Custom Slot was not initialized!");
        }
        return this.delegate.isCaptive(player, menu);
    }

    @Override
    public final boolean isAllowedCaptive(@NotNull Player player, @NotNull Menu menu, @Nullable ItemStack itemStack) {
        if (this.delegate == null) {
            throw new IllegalStateException("Custom Slot was not initialized!");
        }
        return this.delegate.isAllowedCaptive(player, menu, itemStack);
    }

    @Override
    public final boolean isCaptiveFromEmpty() {
        if (this.delegate == null) {
            throw new IllegalStateException("Custom Slot was not initialized!");
        }
        return this.delegate.isCaptiveFromEmpty();
    }

    @Override
    @NotNull
    public final Slot getActionableSlot(@NotNull Player player, @NotNull Menu menu) {
        return this.delegate;
    }

    @Override
    public boolean shouldRenderOnClick(@NotNull ClickType clickType) {
        if (this.delegate == null) {
            throw new IllegalStateException("Custom Slot was not initialized!");
        }
        return this.delegate.shouldRenderOnClick(clickType);
    }

    @Override
    public final int getRows() {
        return Slot.super.getRows();
    }

    @Override
    public final int getColumns() {
        return Slot.super.getColumns();
    }

    @Override
    public final Slot getSlotAt(int row2, int column) {
        return Slot.super.getSlotAt(row2, column);
    }
}

