/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.gui.slot;

import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.gui.slot.functional.CaptiveFilter;
import com.willfp.eco.core.gui.slot.functional.SlotHandler;
import com.willfp.eco.core.gui.slot.functional.SlotModifier;
import com.willfp.eco.core.gui.slot.functional.SlotUpdater;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;

public interface SlotBuilder {
    public SlotBuilder onClick(@NotNull ClickType var1, @NotNull SlotHandler var2);

    default public SlotBuilder onClick(@NotNull ClickType type2, @NotNull BiConsumer<InventoryClickEvent, Slot> action) {
        return this.onClick(type2, (InventoryClickEvent event, Slot slot, Menu menu) -> action.accept(event, slot));
    }

    default public SlotBuilder onLeftClick(@NotNull BiConsumer<InventoryClickEvent, Slot> action) {
        return this.onLeftClick((InventoryClickEvent event, Slot slot, Menu menu) -> action.accept(event, slot));
    }

    default public SlotBuilder onLeftClick(@NotNull SlotHandler handler) {
        return this.onClick(ClickType.LEFT, handler);
    }

    default public SlotBuilder onRightClick(@NotNull BiConsumer<InventoryClickEvent, Slot> action) {
        return this.onRightClick((InventoryClickEvent event, Slot slot, Menu menu) -> action.accept(event, slot));
    }

    default public SlotBuilder onRightClick(@NotNull SlotHandler handler) {
        return this.onClick(ClickType.RIGHT, handler);
    }

    default public SlotBuilder onShiftLeftClick(@NotNull BiConsumer<InventoryClickEvent, Slot> action) {
        return this.onShiftLeftClick((InventoryClickEvent event, Slot slot, Menu menu) -> action.accept(event, slot));
    }

    default public SlotBuilder onShiftLeftClick(@NotNull SlotHandler handler) {
        return this.onClick(ClickType.SHIFT_LEFT, handler);
    }

    default public SlotBuilder onShiftRightClick(@NotNull BiConsumer<InventoryClickEvent, Slot> action) {
        return this.onShiftRightClick((InventoryClickEvent event, Slot slot, Menu menu) -> action.accept(event, slot));
    }

    default public SlotBuilder onShiftRightClick(@NotNull SlotHandler handler) {
        return this.onClick(ClickType.SHIFT_RIGHT, handler);
    }

    default public SlotBuilder onMiddleClick(@NotNull BiConsumer<InventoryClickEvent, Slot> action) {
        return this.onMiddleClick((InventoryClickEvent event, Slot slot, Menu menu) -> action.accept(event, slot));
    }

    default public SlotBuilder onMiddleClick(@NotNull SlotHandler handler) {
        return this.onClick(ClickType.MIDDLE, handler);
    }

    public SlotBuilder notCaptiveFor(@NotNull Predicate<Player> var1);

    default public SlotBuilder setCaptiveFilter(@NotNull CaptiveFilter filter2) {
        return this;
    }

    public SlotBuilder setUpdater(@NotNull SlotUpdater var1);

    default public SlotBuilder setCaptive() {
        return this.setCaptive(false);
    }

    public SlotBuilder setCaptive(boolean var1);

    public Slot build();

    @Deprecated
    default public SlotBuilder setModifier(@NotNull SlotModifier modifier) {
        return this.setUpdater((player, menu, previous) -> {
            modifier.modify(player, menu, previous);
            return previous;
        });
    }
}

