/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.integrations;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class IntegrationLoader {
    private static final Set<String> LOADED_PLUGINS = Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(Plugin::getName).map(String::toLowerCase).collect(Collectors.toSet());
    private final Runnable runnable;
    private final String pluginName;

    public IntegrationLoader(@NotNull String pluginName, @NotNull Runnable onLoad) {
        this.runnable = onLoad;
        this.pluginName = pluginName;
    }

    public void loadIfPresent() {
        if (LOADED_PLUGINS.contains(this.pluginName.toLowerCase())) {
            this.load();
        }
    }

    public void load() {
        this.runnable.run();
    }

    public String getPluginName() {
        return this.pluginName;
    }
}

