/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.integrations.economy;

import com.willfp.eco.core.integrations.economy.EconomyManager;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.OfflinePlayer;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\"(\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\"(\u0010\t\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"value", "", "balance", "Lorg/bukkit/OfflinePlayer;", "getBalance", "(Lorg/bukkit/OfflinePlayer;)D", "setBalance", "(Lorg/bukkit/OfflinePlayer;D)V", "Ljava/math/BigDecimal;", "exactBalance", "getExactBalance", "(Lorg/bukkit/OfflinePlayer;)Ljava/math/BigDecimal;", "setExactBalance", "(Lorg/bukkit/OfflinePlayer;Ljava/math/BigDecimal;)V", "eco-api"})
@JvmName(name="EconomyExtensions")
public final class EconomyExtensions {
    public static final double getBalance(@NotNull OfflinePlayer $this$balance) {
        Intrinsics.checkNotNullParameter($this$balance, "<this>");
        return EconomyManager.getBalance($this$balance);
    }

    public static final void setBalance(@NotNull OfflinePlayer $this$balance, double value) {
        Intrinsics.checkNotNullParameter($this$balance, "<this>");
        if (value <= 0.0) {
            EconomyManager.removeMoney($this$balance, EconomyExtensions.getBalance($this$balance));
            return;
        }
        double diff = EconomyExtensions.getBalance($this$balance) - value;
        if (diff > 0.0) {
            EconomyManager.removeMoney($this$balance, diff);
        } else if (diff < 0.0) {
            EconomyManager.giveMoney($this$balance, -diff);
        }
    }

    @NotNull
    public static final BigDecimal getExactBalance(@NotNull OfflinePlayer $this$exactBalance) {
        Intrinsics.checkNotNullParameter($this$exactBalance, "<this>");
        return new BigDecimal(String.valueOf(EconomyManager.getBalance($this$exactBalance)));
    }

    public static final void setExactBalance(@NotNull OfflinePlayer $this$exactBalance, @NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter($this$exactBalance, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        if (value.compareTo(BigDecimal.ZERO) <= 0) {
            EconomyManager.removeMoney($this$exactBalance, EconomyExtensions.getExactBalance($this$exactBalance));
            return;
        }
        BigDecimal bigDecimal = EconomyExtensions.getExactBalance($this$exactBalance).subtract(value);
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "subtract(...)");
        BigDecimal diff = bigDecimal;
        if (diff.compareTo(BigDecimal.ZERO) > 0) {
            EconomyManager.removeMoney($this$exactBalance, diff);
        } else if (diff.compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal bigDecimal2 = diff.negate();
            Intrinsics.checkNotNullExpressionValue(bigDecimal2, "negate(...)");
            EconomyManager.giveMoney($this$exactBalance, bigDecimal2);
        }
    }
}

