/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.integrations.economy;

import com.willfp.eco.core.integrations.IntegrationRegistry;
import com.willfp.eco.core.integrations.economy.EconomyIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.math.BigDecimal;
import org.bukkit.OfflinePlayer;

public final class EconomyManager {
    private static final IntegrationRegistry<EconomyIntegration> REGISTRY = new IntegrationRegistry();

    public static void register(@NotNull EconomyIntegration integration) {
        REGISTRY.register(integration);
    }

    public static boolean hasRegistrations() {
        return REGISTRY.isNotEmpty();
    }

    public static boolean hasAmount(@NotNull OfflinePlayer player, double amount) {
        return EconomyManager.hasAmount(player, BigDecimal.valueOf(amount));
    }

    public static boolean hasAmount(@NotNull OfflinePlayer player, BigDecimal amount) {
        return REGISTRY.firstSafely(integration -> integration.hasAmount(player, amount), false);
    }

    public static boolean giveMoney(@NotNull OfflinePlayer player, double amount) {
        return EconomyManager.giveMoney(player, BigDecimal.valueOf(amount));
    }

    public static boolean giveMoney(@NotNull OfflinePlayer player, @NotNull BigDecimal amount) {
        return REGISTRY.firstSafely(integration -> integration.giveMoney(player, amount), false);
    }

    public static boolean removeMoney(@NotNull OfflinePlayer player, double amount) {
        return EconomyManager.removeMoney(player, BigDecimal.valueOf(amount));
    }

    public static boolean removeMoney(@NotNull OfflinePlayer player, @NotNull BigDecimal amount) {
        return REGISTRY.firstSafely(integration -> integration.removeMoney(player, amount), false);
    }

    public static double getBalance(@NotNull OfflinePlayer player) {
        return EconomyManager.getExactBalance(player).doubleValue();
    }

    public static BigDecimal getExactBalance(@NotNull OfflinePlayer player) {
        return REGISTRY.firstSafely(integration -> integration.getExactBalance(player), BigDecimal.ZERO);
    }

    private EconomyManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

