/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.integrations.placeholder;

import com.google.common.collect.ImmutableSet;
import com.willfp.eco.core.Eco;
import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.integrations.placeholder.PlaceholderIntegration;
import com.willfp.eco.core.map.DefaultMap;
import com.willfp.eco.core.placeholder.AdditionalPlayer;
import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.Placeholder;
import com.willfp.eco.core.placeholder.PlaceholderInjectable;
import com.willfp.eco.core.placeholder.RegistrablePlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;

public final class PlaceholderManager {
    private static final DefaultMap<EcoPlugin, Set<Placeholder>> REGISTERED_PLACEHOLDERS = new DefaultMap(HashSet::new);
    private static final Set<PlaceholderIntegration> REGISTERED_INTEGRATIONS = new HashSet<PlaceholderIntegration>();
    private static final Pattern PATTERN = Pattern.compile("%([^% ]+)%");
    public static final PlaceholderInjectable EMPTY_INJECTABLE = new PlaceholderInjectable(){

        @Override
        public void addInjectablePlaceholder(@NotNull Iterable<InjectablePlaceholder> placeholders) {
        }

        @Override
        public void clearInjectedPlaceholders() {
        }

        @Override
        @NotNull
        public List<InjectablePlaceholder> getPlaceholderInjections() {
            return Collections.emptyList();
        }
    };

    public static void addIntegration(@NotNull PlaceholderIntegration integration) {
        integration.registerIntegration();
        REGISTERED_INTEGRATIONS.add(integration);
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    public static void registerPlaceholder(@NotNull Placeholder placeholder2) {
        if (!(placeholder2 instanceof RegistrablePlaceholder)) {
            throw new IllegalArgumentException("Placeholder must be RegistrablePlaceholder!");
        }
        PlaceholderManager.registerPlaceholder((RegistrablePlaceholder)placeholder2);
    }

    public static void registerPlaceholder(@NotNull RegistrablePlaceholder placeholder2) {
        HashSet<Placeholder> pluginPlaceholders = new HashSet<Placeholder>((Collection)REGISTERED_PLACEHOLDERS.get(placeholder2.getPlugin()));
        pluginPlaceholders.removeIf(p -> p.getPattern().equals(placeholder2.getPattern()));
        pluginPlaceholders.add(placeholder2);
        REGISTERED_PLACEHOLDERS.put(placeholder2.getPlugin(), (Set<Placeholder>)ImmutableSet.copyOf(pluginPlaceholders));
    }

    @NotNull
    public static String getResult(@Nullable Player player, @NotNull String identifier, @Nullable EcoPlugin plugin) {
        return Objects.requireNonNullElse(PlaceholderManager.getResult(plugin, identifier, new PlaceholderContext(player)), "");
    }

    @Nullable
    public static String getResult(@Nullable EcoPlugin plugin, @NotNull String args2, @NotNull PlaceholderContext context) {
        return Eco.get().getPlaceholderValue(plugin, args2, context);
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    @NotNull
    public static String translatePlaceholders(@NotNull String text, @Nullable Player player) {
        return PlaceholderManager.translatePlaceholders(text, player, EMPTY_INJECTABLE);
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    @NotNull
    public static String translatePlaceholders(@NotNull String text, @Nullable Player player, @NotNull PlaceholderInjectable context) {
        return PlaceholderManager.translatePlaceholders(text, new PlaceholderContext(player, null, context, new ArrayList<AdditionalPlayer>()));
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    @NotNull
    public static String translatePlaceholders(@NotNull String text, @Nullable Player player, @NotNull PlaceholderInjectable context, @NotNull Collection<AdditionalPlayer> additionalPlayers) {
        return PlaceholderManager.translatePlaceholders(text, new PlaceholderContext(player, null, context, additionalPlayers));
    }

    @NotNull
    public static String translatePlaceholders(@NotNull String text) {
        return Eco.get().translatePlaceholders(text, PlaceholderContext.EMPTY);
    }

    @NotNull
    public static String translatePlaceholders(@NotNull String text, @NotNull PlaceholderContext context) {
        return Eco.get().translatePlaceholders(text, context);
    }

    public static List<String> findPlaceholdersIn(@NotNull String text) {
        HashSet<String> found = new HashSet<String>();
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            found.add(matcher.group());
        }
        for (PlaceholderIntegration integration : REGISTERED_INTEGRATIONS) {
            found.addAll(integration.findPlaceholdersIn(text));
        }
        return new ArrayList<String>(found);
    }

    public static Set<PlaceholderIntegration> getRegisteredIntegrations() {
        return Set.copyOf(REGISTERED_INTEGRATIONS);
    }

    public static Set<Placeholder> getRegisteredPlaceholders(@NotNull EcoPlugin plugin) {
        return REGISTERED_PLACEHOLDERS.get(plugin);
    }

    private PlaceholderManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

