/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.integrations.shop;

import com.willfp.eco.core.integrations.IntegrationRegistry;
import com.willfp.eco.core.integrations.shop.ShopIntegration;
import com.willfp.eco.core.price.Price;
import com.willfp.eco.core.price.impl.PriceFree;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class ShopManager {
    private static final IntegrationRegistry<ShopIntegration> REGISTRY = new IntegrationRegistry();

    public static void register(@NotNull ShopIntegration integration) {
        REGISTRY.register(integration);
    }

    public static void registerEcoProvider() {
        REGISTRY.forEachSafely(ShopIntegration::registerEcoProvider);
    }

    public static boolean isSellable(@Nullable ItemStack itemStack, @NotNull Player player) {
        if (itemStack == null) {
            return false;
        }
        return REGISTRY.anySafely(integration -> integration.isSellable(itemStack, player));
    }

    @NotNull
    public static Price getUnitValue(@Nullable ItemStack itemStack, @NotNull Player player) {
        if (itemStack == null) {
            return new PriceFree();
        }
        return REGISTRY.firstSafely(integration -> integration.getUnitValue(itemStack, player), new PriceFree());
    }

    @Deprecated(since="6.47.0", forRemoval=true)
    public static double getItemPrice(@Nullable ItemStack itemStack) {
        return ShopManager.getItemPrice(itemStack, null);
    }

    @Deprecated(since="6.47.0", forRemoval=true)
    public static double getItemPrice(@Nullable ItemStack itemStack, @Nullable Player player) {
        if (itemStack == null || player == null) {
            return 0.0;
        }
        return REGISTRY.firstSafely(integration -> integration.getUnitValue(itemStack, player).getValue(player, itemStack.getAmount()), 0.0);
    }

    public static Set<ShopIntegration> getRegisteredIntegrations() {
        return new HashSet<ShopIntegration>(REGISTRY.values());
    }

    private ShopManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

