/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.items;

import com.willfp.eco.core.fast.FastItemStack;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import org.bukkit.inventory.ItemStack;

public final class HashedItem {
    private final ItemStack item;
    private final int hash;

    private HashedItem(@NotNull ItemStack item, int hash) {
        this.item = item;
        this.hash = hash;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getHash() {
        return this.hash;
    }

    public ItemStack component1() {
        return this.getItem();
    }

    public int component2() {
        return this.getHash();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof HashedItem)) {
            return false;
        }
        HashedItem o = (HashedItem)other;
        return o.hash == this.hash;
    }

    public static HashedItem of(@NotNull ItemStack item) {
        return new HashedItem(item, FastItemStack.wrap(item).hashCode());
    }

    public static HashedItem of(@NotNull FastItemStack item) {
        return new HashedItem(item.unwrap(), item.hashCode());
    }
}

