/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.items;

import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000f\u0010\u000e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u000f*\u00020\u0003\u001a\u001e\u0010\u0010\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u001a\u0018\u0010\u0010\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u0003\u001a\u0012\u0010\u0015\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003\u001a\u0012\u0010\u0015\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017\u001a\f\u0010\u0018\u001a\u00020\u0019*\u0004\u0018\u00010\u0003\u001a\u000f\u0010\u001a\u001a\u00070\u0019\u00a2\u0006\u0002\b\u000f*\u00020\u0003\"(\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\"\u0017\u0010\b\u001a\u00020\t*\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\" \u0010\u000b\u001a\u00020\t*\u0004\u0018\u00010\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u001b"}, d2={"value", "Lorg/bukkit/persistence/PersistentDataContainer;", "baseNBT", "Lorg/bukkit/inventory/ItemStack;", "getBaseNBT", "(Lorg/bukkit/inventory/ItemStack;)Lorg/bukkit/persistence/PersistentDataContainer;", "setBaseNBT", "(Lorg/bukkit/inventory/ItemStack;Lorg/bukkit/persistence/PersistentDataContainer;)V", "isEcoEmpty", "", "(Lorg/bukkit/inventory/ItemStack;)Z", "isEmpty", "isEmpty$annotations", "(Lorg/bukkit/inventory/ItemStack;)V", "clearNBT", "Lcom/willfp/eco/libs/jetbrains/annotations/NotNull;", "matches", "", "Lcom/willfp/eco/core/items/TestableItem;", "items", "item", "mergeFrom", "other", "Lorg/bukkit/inventory/meta/ItemMeta;", "toLookupString", "", "toSNBT", "eco-api"})
@JvmName(name="ItemsExtensions")
public final class ItemsExtensions {
    @NotNull
    public static final String toLookupString(@Nullable ItemStack $this$toLookupString) {
        String string = Items.toLookupString($this$toLookupString);
        Intrinsics.checkNotNullExpressionValue(string, "toLookupString(...)");
        return string;
    }

    @NotNull
    public static final ItemStack mergeFrom(@NotNull ItemStack $this$mergeFrom, @NotNull ItemStack other) {
        Intrinsics.checkNotNullParameter($this$mergeFrom, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        ItemStack itemStack = Items.mergeFrom(other, $this$mergeFrom);
        Intrinsics.checkNotNullExpressionValue(itemStack, "mergeFrom(...)");
        return itemStack;
    }

    @NotNull
    public static final ItemMeta mergeFrom(@NotNull ItemMeta $this$mergeFrom, @NotNull ItemMeta other) {
        Intrinsics.checkNotNullParameter($this$mergeFrom, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        ItemMeta itemMeta = Items.mergeFrom(other, $this$mergeFrom);
        Intrinsics.checkNotNullExpressionValue(itemMeta, "mergeFrom(...)");
        return itemMeta;
    }

    @NotNull
    public static final PersistentDataContainer getBaseNBT(@NotNull ItemStack $this$baseNBT) {
        Intrinsics.checkNotNullParameter($this$baseNBT, "<this>");
        PersistentDataContainer persistentDataContainer = Items.getBaseNBT($this$baseNBT);
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getBaseNBT(...)");
        return persistentDataContainer;
    }

    public static final void setBaseNBT(@NotNull ItemStack $this$baseNBT, @NotNull PersistentDataContainer value) {
        Intrinsics.checkNotNullParameter($this$baseNBT, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        Items.setBaseNBT($this$baseNBT, value);
    }

    @NotNull
    public static final ItemStack clearNBT(@NotNull ItemStack $this$clearNBT) {
        Intrinsics.checkNotNullParameter($this$clearNBT, "<this>");
        ItemStack itemStack = Items.setBaseNBT($this$clearNBT, null);
        Intrinsics.checkNotNullExpressionValue(itemStack, "setBaseNBT(...)");
        return itemStack;
    }

    @NotNull
    public static final String toSNBT(@NotNull ItemStack $this$toSNBT) {
        Intrinsics.checkNotNullParameter($this$toSNBT, "<this>");
        String string = Items.toSNBT($this$toSNBT);
        Intrinsics.checkNotNullExpressionValue(string, "toSNBT(...)");
        return string;
    }

    public static final boolean isEmpty(@Nullable ItemStack $this$isEmpty) {
        return Items.isEmpty($this$isEmpty);
    }

    @Deprecated(message="Use ItemStack.isEcoEmpty", replaceWith=@ReplaceWith(expression="Items.isEmpty(this)", imports={}))
    public static /* synthetic */ void isEmpty$annotations(ItemStack itemStack) {
    }

    public static final boolean isEcoEmpty(@Nullable ItemStack $this$isEcoEmpty) {
        return Items.isEmpty($this$isEcoEmpty);
    }

    public static final boolean matches(@NotNull Collection<? extends TestableItem> $this$matches, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter($this$matches, "<this>");
        Intrinsics.checkNotNullParameter(item, "item");
        return Items.matchesAny(item, $this$matches);
    }

    public static final boolean matches(@NotNull Collection<? extends TestableItem> $this$matches, @NotNull Collection<? extends ItemStack> items) {
        Intrinsics.checkNotNullParameter($this$matches, "<this>");
        Intrinsics.checkNotNullParameter(items, "items");
        return Items.matchesAny(items, $this$matches);
    }
}

