/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.items.builder;

import com.willfp.eco.core.fast.FastItemStack;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.core.items.builder.ItemBuilder;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.StringUtils;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public abstract class AbstractItemStackBuilder<T extends ItemMeta, U extends AbstractItemStackBuilder<T, U>>
implements ItemBuilder {
    private T meta;
    private final ItemStack base;

    protected AbstractItemStackBuilder(@NotNull Material material) {
        this(new ItemStack(material));
    }

    protected AbstractItemStackBuilder(@NotNull TestableItem item) {
        this(item.getItem());
    }

    protected AbstractItemStackBuilder(@NotNull ItemStack base) {
        if (base.getType() == Material.AIR) {
            base.setType(Material.STONE);
        }
        this.base = base;
        this.meta = base.getItemMeta();
        assert (this.meta != null);
    }

    public U setAmount(int amount) {
        Validate.isTrue((amount >= 1 ? 1 : 0) != 0);
        this.base.setAmount(amount);
        return (U)this;
    }

    public U setAmount(@NotNull Supplier<Integer> amount) {
        return (U)this.setAmount(amount.get());
    }

    public U addEnchantment(@NotNull Enchantment enchantment, int level) {
        if (enchantment == null) {
            return (U)this;
        }
        this.meta.addEnchant(enchantment, level, true);
        return (U)this;
    }

    public U addEnchantment(@NotNull Supplier<Enchantment> enchantment, @NotNull Supplier<Integer> level) {
        return (U)this.addEnchantment(enchantment.get(), level.get());
    }

    public U setDisplayName(@NotNull String name) {
        this.meta.setDisplayName(StringUtils.format(name));
        return (U)this;
    }

    public U setDisplayName(@NotNull Supplier<String> name) {
        String result2 = name.get();
        return (U)(result2 == null ? this : this.setDisplayName(name.get()));
    }

    public U addLoreLine(@NotNull String line) {
        this.base.setItemMeta(this.meta);
        FastItemStack fis = FastItemStack.wrap(this.base);
        List<String> lore = fis.getLore();
        lore.add(StringUtils.format(line));
        fis.setLore(lore);
        this.meta = this.base.getItemMeta();
        return (U)this;
    }

    public U addLoreLine(@NotNull Supplier<String> line) {
        String result2 = line.get();
        return (U)(result2 == null ? this : this.addLoreLine(line.get()));
    }

    public U addLoreLines(@NotNull List<String> lines) {
        this.base.setItemMeta(this.meta);
        FastItemStack fis = FastItemStack.wrap(this.base);
        List<String> lore = fis.getLore();
        for (String line : lines) {
            lore.add(StringUtils.format(line));
        }
        fis.setLore(lore);
        this.meta = this.base.getItemMeta();
        return (U)this;
    }

    public U addLoreLines(@NotNull Supplier<List<String>> lines) {
        List<String> result2 = lines.get();
        return (U)(result2 == null ? this : this.addLoreLines((List)lines.get()));
    }

    public U addItemFlag(ItemFlag ... itemFlags) {
        this.meta.addItemFlags(itemFlags);
        return (U)this;
    }

    public U addItemFlag(@NotNull Supplier<ItemFlag[]> itemFlags) {
        ItemFlag[] result2 = itemFlags.get();
        return (U)(result2 == null ? this : this.addItemFlag(result2));
    }

    public <A, B> U writeMetaKey(@NotNull NamespacedKey key, @NotNull PersistentDataType<A, B> type2, @NotNull B value) {
        this.meta.getPersistentDataContainer().set(key, type2, value);
        return (U)this;
    }

    public <A, B> U writeMetaKey(@NotNull Supplier<NamespacedKey> key, @NotNull Supplier<PersistentDataType<A, B>> type2, @NotNull Supplier<B> value) {
        return (U)this.writeMetaKey(key.get(), (PersistentDataType)type2.get(), (Object)value.get());
    }

    public U setUnbreakable(boolean unbreakable) {
        this.meta.setUnbreakable(unbreakable);
        return (U)this;
    }

    public U setUnbreakable(@NotNull Supplier<Boolean> unbreakable) {
        Boolean result2 = unbreakable.get();
        return (U)(result2 == null ? this : this.setUnbreakable((Supplier)unbreakable));
    }

    public U setCustomModelData(@Nullable Integer data2) {
        this.meta.setCustomModelData(data2);
        return (U)this;
    }

    public U setCustomModelData(@NotNull Supplier<Integer> data2) {
        Integer result2 = data2.get();
        return (U)(result2 == null ? this : this.setCustomModelData(result2));
    }

    @Override
    public ItemStack build() {
        this.base.setItemMeta(this.meta);
        return this.base;
    }

    protected ItemStack getBase() {
        return this.base;
    }

    protected T getMeta() {
        return this.meta;
    }
}

