/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.placeholder;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.placeholder.RegistrablePlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;

public final class PlayerDynamicPlaceholder
implements RegistrablePlaceholder {
    private final Pattern pattern;
    private final BiFunction<@NotNull String, @NotNull Player, @Nullable String> function;
    private final EcoPlugin plugin;

    public PlayerDynamicPlaceholder(@NotNull EcoPlugin plugin, @NotNull Pattern pattern, @NotNull @NotNull BiFunction<@NotNull String, @NotNull Player, @Nullable String> function) {
        this.plugin = plugin;
        this.pattern = pattern;
        this.function = function;
    }

    @Override
    @Nullable
    public String getValue(@NotNull String args2, @NotNull PlaceholderContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return null;
        }
        return this.function.apply(args2, player);
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    @NotNull
    public String getValue(@NotNull String args2, @NotNull Player player) {
        return Objects.requireNonNullElse(this.function.apply(args2, player), "");
    }

    @Override
    @NotNull
    public EcoPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public PlayerDynamicPlaceholder register() {
        return (PlayerDynamicPlaceholder)RegistrablePlaceholder.super.register();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerDynamicPlaceholder)) {
            return false;
        }
        PlayerDynamicPlaceholder that = (PlayerDynamicPlaceholder)o;
        return Objects.equals(this.getPattern(), that.getPattern()) && Objects.equals(this.getPlugin(), that.getPlugin());
    }

    public int hashCode() {
        return Objects.hash(this.getPattern(), this.getPlugin());
    }
}

