/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.placeholder;

import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.PatternUtils;
import com.willfp.eco.util.StringUtils;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class StaticPlaceholder
implements InjectablePlaceholder {
    private final String identifier;
    private final Pattern pattern;
    private final Supplier<@Nullable String> function;

    public StaticPlaceholder(@NotNull String identifier, @NotNull Supplier<@Nullable String> function) {
        this.identifier = "%" + identifier + "%";
        this.pattern = PatternUtils.compileLiteral(identifier);
        this.function = function;
    }

    @Override
    @Nullable
    public String getValue(@NotNull String args2, @NotNull PlaceholderContext context) {
        return this.function.get();
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    @NotNull
    public String getValue() {
        return Objects.requireNonNullElse(this.function.get(), "");
    }

    @Override
    public String tryTranslateQuickly(@NotNull String text, @NotNull PlaceholderContext context) {
        return StringUtils.replaceQuickly(text, this.identifier, Objects.requireNonNullElse(this.getValue(this.identifier, context), ""));
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StaticPlaceholder)) {
            return false;
        }
        StaticPlaceholder that = (StaticPlaceholder)o;
        return Objects.equals(this.getPattern(), that.getPattern());
    }

    public int hashCode() {
        return Objects.hash(this.getPattern());
    }
}

