/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.placeholder.context;

import com.willfp.eco.core.math.MathContext;
import com.willfp.eco.core.placeholder.AdditionalPlayer;
import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.PlaceholderInjectable;
import com.willfp.eco.core.placeholder.context.MergedInjectableContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlaceholderContext {
    private static final PlaceholderInjectable EMPTY_INJECTABLE = new PlaceholderInjectable(){

        @Override
        public void addInjectablePlaceholder(@NotNull Iterable<InjectablePlaceholder> placeholders) {
        }

        @Override
        public void clearInjectedPlaceholders() {
        }

        @Override
        @NotNull
        public List<InjectablePlaceholder> getPlaceholderInjections() {
            return Collections.emptyList();
        }
    };
    public static final PlaceholderContext EMPTY = new PlaceholderContext(null, null, null, Collections.emptyList());
    @Nullable
    private final Player player;
    @Nullable
    private final ItemStack itemStack;
    @NotNull
    private final PlaceholderInjectable injectableContext;
    @NotNull
    private final Collection<AdditionalPlayer> additionalPlayers;

    public PlaceholderContext() {
        this(null, null, null, Collections.emptyList());
    }

    public PlaceholderContext(@Nullable Player player) {
        this(player, null, null, Collections.emptyList());
    }

    public PlaceholderContext(@Nullable Player player, @Nullable ItemStack itemStack, @Nullable PlaceholderInjectable injectableContext, @NotNull Collection<AdditionalPlayer> additionalPlayers) {
        this.player = player;
        this.itemStack = itemStack;
        this.injectableContext = Objects.requireNonNullElse(injectableContext, EMPTY_INJECTABLE);
        this.additionalPlayers = additionalPlayers;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @NotNull
    public PlaceholderInjectable getInjectableContext() {
        return this.injectableContext;
    }

    @NotNull
    public Collection<AdditionalPlayer> getAdditionalPlayers() {
        return this.additionalPlayers;
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    public MathContext toMathContext() {
        return new MathContext(this.getInjectableContext(), this.getPlayer(), this.getAdditionalPlayers());
    }

    public PlaceholderContext copyWithPlayer(@Nullable Player player) {
        return new PlaceholderContext(player, this.getItemStack(), this.getInjectableContext(), this.getAdditionalPlayers());
    }

    public PlaceholderContext copyWithItem(@Nullable ItemStack itemStack) {
        return new PlaceholderContext(this.getPlayer(), itemStack, this.getInjectableContext(), this.getAdditionalPlayers());
    }

    public PlaceholderContext withInjectableContext(@NotNull PlaceholderInjectable injectableContext) {
        return new PlaceholderContext(this.getPlayer(), this.getItemStack(), new MergedInjectableContext(this.getInjectableContext(), injectableContext), this.getAdditionalPlayers());
    }

    public String toString() {
        return "PlaceholderContext{player=" + this.player + ", itemStack=" + this.itemStack + ", injectableContext=" + this.injectableContext + ", additionalPlayers=" + this.additionalPlayers + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlaceholderContext)) {
            return false;
        }
        PlaceholderContext that = (PlaceholderContext)o;
        return Objects.equals(this.getPlayer(), that.getPlayer()) && Objects.equals(this.getItemStack(), that.getItemStack()) && this.getInjectableContext().equals(that.getInjectableContext()) && this.getAdditionalPlayers().equals(that.getAdditionalPlayers());
    }

    public int hashCode() {
        return Objects.hash(this.getPlayer(), this.getItemStack(), this.getInjectableContext(), this.getAdditionalPlayers());
    }

    public static PlaceholderContext of(@NotNull PlaceholderInjectable injectableContext) {
        return new PlaceholderContext(null, null, injectableContext, Collections.emptyList());
    }
}

