/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.price;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.core.price.Price;
import com.willfp.eco.core.price.Prices;
import com.willfp.eco.core.price.impl.PriceFree;
import com.willfp.eco.core.serialization.ConfigDeserializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NumberUtils;
import com.willfp.eco.util.StringUtils;
import java.util.Objects;
import org.bukkit.entity.Player;

public final class ConfiguredPrice
implements Price {
    private static final ConfigDeserializer<ConfiguredPrice> DESERIALIZER = new Deserializer();
    public static final ConfiguredPrice FREE = new ConfiguredPrice(new PriceFree(), "Free");
    private final Price price;
    private final String formatString;

    public ConfiguredPrice(@NotNull Price price, @NotNull String formatString) {
        this.price = price;
        this.formatString = formatString;
    }

    @Override
    public boolean canAfford(@NotNull Player player, double multiplier) {
        return this.price.canAfford(player, multiplier);
    }

    @Override
    public void pay(@NotNull Player player, double multiplier) {
        this.price.pay(player, multiplier);
    }

    @Override
    public void giveTo(@NotNull Player player, double multiplier) {
        this.price.giveTo(player, multiplier);
    }

    @Override
    public double getValue(@NotNull Player player, double multiplier) {
        return this.price.getValue(player, multiplier);
    }

    @Override
    public double getMultiplier(@NotNull Player player) {
        return this.price.getMultiplier(player);
    }

    @Override
    public void setMultiplier(@NotNull Player player, double multiplier) {
        this.price.setMultiplier(player, multiplier);
    }

    @Override
    public String getIdentifier() {
        return this.price.getIdentifier();
    }

    public Price getPrice() {
        return this.price;
    }

    public String getDisplay(@NotNull Player player) {
        return this.getDisplay(player, 1.0);
    }

    public String getDisplay(@NotNull Player player, double multiplier) {
        double value = this.getPrice().getValue(player, multiplier);
        return StringUtils.format(this.formatString.replace("%value%", NumberUtils.format(value)).replace("%value_commas%", NumberUtils.formatWithCommas(value)), player, StringUtils.FormatOption.WITH_PLACEHOLDERS);
    }

    @Nullable
    public static ConfiguredPrice create(@NotNull Config config) {
        return DESERIALIZER.deserialize(config);
    }

    @NotNull
    public static ConfiguredPrice createOrFree(@NotNull Config config) {
        return Objects.requireNonNullElse(ConfiguredPrice.create(config), FREE);
    }

    private static final class Deserializer
    implements ConfigDeserializer<ConfiguredPrice> {
        private Deserializer() {
        }

        @Override
        @Nullable
        public ConfiguredPrice deserialize(@NotNull Config config) {
            String formatString;
            if (!config.has("value") || !config.has("type")) {
                return null;
            }
            String langConfig = Eco.get().getEcoPlugin().getLangYml().getSubsections("price-display").stream().filter(section -> section.getString("type").equalsIgnoreCase(config.getString("type"))).findFirst().map(section -> section.getString("display")).orElse(null);
            if (langConfig != null) {
                formatString = langConfig;
            } else if (config.has("display")) {
                formatString = config.getString("display");
            } else {
                return null;
            }
            Price price = Prices.create(config.getString("value"), config.getString("type"), PlaceholderContext.of(config));
            return new ConfiguredPrice(price, formatString);
        }
    }
}

