/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.price;

import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.core.math.MathContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContextSupplier;
import com.willfp.eco.core.price.Price;
import com.willfp.eco.core.price.PriceFactory;
import com.willfp.eco.core.price.impl.PriceEconomy;
import com.willfp.eco.core.price.impl.PriceFree;
import com.willfp.eco.core.price.impl.PriceItem;
import com.willfp.eco.core.recipe.parts.EmptyTestableItem;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NumberUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Prices {
    private static final Map<String, PriceFactory> FACTORIES = new ConcurrentHashMap<String, PriceFactory>();

    public static void registerPriceFactory(@NotNull PriceFactory factory) {
        for (String name : factory.getNames()) {
            FACTORIES.put(name.toLowerCase(), factory);
        }
    }

    @NotNull
    public static Price create(@NotNull String expression, @Nullable String priceName) {
        return Prices.create(expression, priceName, PlaceholderContext.EMPTY);
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    @NotNull
    public static Price create(@NotNull String expression, @Nullable String priceName, @NotNull MathContext context) {
        return Prices.create(expression, priceName, context.toPlaceholderContext());
    }

    @NotNull
    public static Price create(@NotNull String expression, @Nullable String priceName, @NotNull PlaceholderContext context) {
        PlaceholderContextSupplier<Double> function = ctx -> NumberUtils.evaluateExpression(expression, ctx);
        if (priceName == null) {
            return new PriceEconomy(context, function);
        }
        PriceFactory factory = FACTORIES.get(priceName);
        if (factory == null) {
            TestableItem item = Items.lookup(priceName);
            if (item instanceof EmptyTestableItem) {
                return new PriceFree();
            }
            return new PriceItem(context, function, item);
        }
        return factory.create(context, function);
    }

    private Prices() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

