/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.price.impl;

import com.willfp.eco.core.drops.DropQueue;
import com.willfp.eco.core.items.HashedItem;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.core.math.MathContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContextSupplier;
import com.willfp.eco.core.price.Price;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class PriceItem
implements Price {
    private final PlaceholderContext baseContext;
    private final PlaceholderContextSupplier<Double> function;
    private final TestableItem item;
    private final Map<UUID, Double> multipliers = new HashMap<UUID, Double>();

    public PriceItem(int amount, @NotNull TestableItem item) {
        this(PlaceholderContext.EMPTY, (PlaceholderContext ctx) -> amount, item);
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    public PriceItem(@NotNull MathContext baseContext, @NotNull Function<MathContext, Double> function, @NotNull TestableItem item) {
        this(baseContext.toPlaceholderContext(), (PlaceholderContext ctx) -> (Double)function.apply(ctx.toMathContext()), item);
    }

    public PriceItem(@NotNull PlaceholderContext baseContext, @NotNull PlaceholderContextSupplier<Double> function, @NotNull TestableItem item) {
        this.baseContext = baseContext;
        this.function = function;
        this.item = item;
    }

    public TestableItem getItem() {
        return this.item;
    }

    @Override
    public boolean canAfford(@NotNull Player player, double multiplier) {
        int toRemove = (int)this.getValue(player, multiplier);
        if (toRemove <= 0) {
            return true;
        }
        int count2 = 0;
        for (ItemStack itemStack : player.getInventory().getContents()) {
            if (!this.item.matches(itemStack)) continue;
            count2 += itemStack.getAmount();
        }
        return count2 >= toRemove;
    }

    @Override
    public void pay(@NotNull Player player, double multiplier) {
        int toRemove = (int)this.getValue(player, multiplier);
        int count2 = 0;
        for (ItemStack itemStack : player.getInventory().getContents()) {
            if (count2 >= toRemove) break;
            if (!this.item.matches(itemStack)) continue;
            int itemAmount = itemStack.getAmount();
            if (itemAmount > toRemove) {
                itemStack.setAmount(itemAmount - toRemove);
            }
            if (itemAmount <= toRemove) {
                itemStack.setAmount(0);
                itemStack.setType(Material.AIR);
            }
            count2 += itemAmount;
        }
    }

    @Override
    public void giveTo(@NotNull Player player, double multiplier) {
        ItemStack itemStack = this.item.getItem().clone();
        itemStack.setAmount((int)this.getValue(player, multiplier));
        new DropQueue(player).addItem(itemStack).forceTelekinesis().push();
    }

    @Override
    public double getValue(@NotNull Player player, double multiplier) {
        return Math.toIntExact(Math.round(this.function.get(this.baseContext.copyWithPlayer(player)) * this.getMultiplier(player) * multiplier));
    }

    @Override
    public double getMultiplier(@NotNull Player player) {
        return this.multipliers.getOrDefault(player.getUniqueId(), 1.0);
    }

    @Override
    public void setMultiplier(@NotNull Player player, double multiplier) {
        this.multipliers.put(player.getUniqueId(), multiplier);
    }

    @Override
    public String getIdentifier() {
        return "eco:item-" + HashedItem.of(this.item.getItem()).getHash();
    }
}

