/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.recipe.parts;

import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;

public class GroupedTestableItems
implements TestableItem {
    private final Collection<TestableItem> children;

    public GroupedTestableItems(@NotNull Collection<TestableItem> children2) {
        Validate.isTrue((!children2.isEmpty() ? 1 : 0) != 0, (String)"Group must have at least one child!");
        this.children = children2;
    }

    @Override
    public boolean matches(@Nullable ItemStack itemStack) {
        for (TestableItem child : this.children) {
            if (!child.matches(itemStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getItem() {
        Iterator<TestableItem> iterator2 = this.children.iterator();
        if (iterator2.hasNext()) {
            TestableItem child = iterator2.next();
            return child.getItem();
        }
        throw new IllegalStateException("Empty group of children!");
    }

    @Nullable
    public TestableItem getMatchingChild(@NotNull ItemStack itemStack) {
        for (TestableItem child : this.children) {
            if (!child.matches(itemStack)) continue;
            return child;
        }
        return null;
    }

    public Collection<TestableItem> getChildren() {
        return new ArrayList<TestableItem>(this.children);
    }
}

