/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.recipe.parts;

import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MaterialTestableItem
implements TestableItem {
    private final Material material;

    public MaterialTestableItem(@NotNull Material material) {
        Validate.isTrue((material != Material.AIR ? 1 : 0) != 0, (String)"You can't have air as the type!");
        this.material = material;
    }

    @Override
    public boolean matches(@Nullable ItemStack itemStack) {
        boolean simpleMatches;
        boolean bl = simpleMatches = itemStack != null && itemStack.getType() == this.material;
        if (!simpleMatches) {
            return false;
        }
        return !Items.isCustomItem(itemStack);
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack(this.material);
    }

    public Material getMaterial() {
        return this.material;
    }
}

