/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.recipe.parts;

import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.core.recipe.parts.EmptyTestableItem;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;

public class TestableStack
implements TestableItem {
    private final TestableItem handle;
    private final int amount;

    public TestableStack(@NotNull TestableItem item, int amount) {
        Validate.isTrue((!(item instanceof TestableStack) ? 1 : 0) != 0, (String)"You can't stack a stack!");
        Validate.isTrue((!(item instanceof EmptyTestableItem) ? 1 : 0) != 0, (String)"You can't stack air!");
        this.handle = item;
        this.amount = amount;
    }

    @Override
    public boolean matches(@Nullable ItemStack itemStack) {
        return itemStack != null && this.handle.matches(itemStack) && itemStack.getAmount() >= this.amount;
    }

    @Override
    public ItemStack getItem() {
        ItemStack temp = this.handle.getItem().clone();
        temp.setAmount(this.amount);
        return temp;
    }

    public TestableItem getHandle() {
        return this.handle;
    }

    public int getAmount() {
        return this.amount;
    }
}

