/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.recipe.recipes;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.core.recipe.Recipes;
import com.willfp.eco.core.recipe.parts.EmptyTestableItem;
import com.willfp.eco.core.recipe.parts.GroupedTestableItems;
import com.willfp.eco.core.recipe.parts.TestableStack;
import com.willfp.eco.core.recipe.recipes.CraftingRecipe;
import com.willfp.eco.core.recipe.recipes.RecipePosition;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public final class ShapedCraftingRecipe
implements CraftingRecipe {
    private final EcoPlugin plugin;
    private final List<TestableItem> parts;
    private final NamespacedKey key;
    private final NamespacedKey displayedKey;
    private final ItemStack output;
    private final String permission;

    private ShapedCraftingRecipe(@NotNull EcoPlugin plugin, @NotNull String key, @NotNull List<TestableItem> parts, @NotNull ItemStack output, @Nullable String permission) {
        this.plugin = plugin;
        this.parts = parts;
        this.key = plugin.getNamespacedKeyFactory().create(key);
        this.displayedKey = plugin.getNamespacedKeyFactory().create(key + "_displayed");
        this.output = output;
        this.permission = permission;
    }

    @Override
    public boolean test(@Nullable ItemStack[] matrix) {
        if (matrix == null) {
            return false;
        }
        List<ItemStack> dynamicMatrix = Arrays.asList(matrix);
        boolean matches = true;
        for (int i = 0; i < 9; ++i) {
            if (this.parts.get(i).matches(ListUtils.getOrNull(dynamicMatrix, i))) continue;
            matches = false;
        }
        return matches;
    }

    @Override
    public void register() {
        Recipes.register(this);
        Bukkit.getServer().removeRecipe(this.getKey());
        Bukkit.getServer().removeRecipe(this.getDisplayedKey());
        ShapedRecipe shapedRecipe = new ShapedRecipe(this.getKey(), this.getOutput());
        shapedRecipe.shape(new String[]{"012", "345", "678"});
        for (int i = 0; i < 9; ++i) {
            if (this.parts.get(i) instanceof EmptyTestableItem) continue;
            char character = String.valueOf(i).toCharArray()[0];
            shapedRecipe.setIngredient(character, this.parts.get(i).getItem().getType());
        }
        if (Eco.get().getEcoPlugin().getConfigYml().getBool("displayed-recipes")) {
            ShapedRecipe displayedRecipe = new ShapedRecipe(this.getDisplayedKey(), this.getOutput());
            displayedRecipe.shape(new String[]{"012", "345", "678"});
            for (int i = 0; i < 9; ++i) {
                if (this.parts.get(i) instanceof EmptyTestableItem) continue;
                char character = String.valueOf(i).toCharArray()[0];
                ArrayList<TestableItem> items = new ArrayList<TestableItem>();
                TestableItem testableItem = this.parts.get(i);
                if (testableItem instanceof GroupedTestableItems) {
                    GroupedTestableItems group = (GroupedTestableItems)testableItem;
                    items.addAll(group.getChildren());
                } else {
                    items.add(this.parts.get(i));
                }
                ArrayList<ItemStack> displayedItems = new ArrayList<ItemStack>();
                for (TestableItem testableItem2 : items) {
                    if (testableItem2 instanceof TestableStack) {
                        List lore;
                        ItemStack item = testableItem2.getItem().clone();
                        ItemMeta meta = item.getItemMeta();
                        assert (meta != null);
                        List list = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                        assert (lore != null);
                        lore.add("");
                        String add = Eco.get().getEcoPlugin().getLangYml().getFormattedString("multiple-in-craft");
                        add = add.replace("%amount%", String.valueOf(item.getAmount()));
                        lore.add(add);
                        meta.setLore(lore);
                        item.setItemMeta(meta);
                        displayedItems.add(item);
                        continue;
                    }
                    displayedItems.add(testableItem2.getItem());
                }
                displayedRecipe.setIngredient(character, (RecipeChoice)new RecipeChoice.ExactChoice(displayedItems));
            }
            Bukkit.getServer().addRecipe((Recipe)displayedRecipe);
        }
        Bukkit.getServer().addRecipe((Recipe)shapedRecipe);
    }

    public EcoPlugin getPlugin() {
        return this.plugin;
    }

    public static Builder builder(@NotNull EcoPlugin plugin, @NotNull String key) {
        return new Builder(plugin, key);
    }

    @Override
    @NotNull
    public List<TestableItem> getParts() {
        return this.parts;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public NamespacedKey getDisplayedKey() {
        return this.displayedKey;
    }

    @Override
    @NotNull
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    @Nullable
    public String getPermission() {
        return this.permission;
    }

    public static final class Builder {
        private final List<TestableItem> recipeParts = new ArrayList<TestableItem>(Arrays.asList(null, null, null, null, null, null, null, null, null));
        private ItemStack output = null;
        private String permission = null;
        private final String key;
        private final EcoPlugin plugin;

        private Builder(@NotNull EcoPlugin plugin, @NotNull String key) {
            this.key = key;
            this.plugin = plugin;
        }

        public Builder setRecipePart(@NotNull RecipePosition position, @NotNull TestableItem part) {
            this.recipeParts.set(position.getIndex(), part);
            return this;
        }

        public Builder setRecipePart(int position, @NotNull TestableItem part) {
            this.recipeParts.set(position, part);
            return this;
        }

        public Builder setOutput(@NotNull ItemStack output) {
            this.output = output;
            return this;
        }

        public Builder setPermission(@Nullable String permission) {
            this.permission = permission;
            return this;
        }

        public boolean isAir() {
            for (TestableItem recipePart : this.recipeParts) {
                if (recipePart == null || recipePart instanceof EmptyTestableItem) continue;
                return false;
            }
            return true;
        }

        public ShapedCraftingRecipe build() {
            for (int i = 0; i < 9; ++i) {
                if (this.recipeParts.get(i) != null) continue;
                this.recipeParts.set(i, new EmptyTestableItem());
            }
            return new ShapedCraftingRecipe(this.plugin, this.key.toLowerCase(), this.recipeParts, this.output, this.permission);
        }
    }
}

