/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.recipe.recipes;

import com.google.common.annotations.Beta;
import com.willfp.eco.core.Eco;
import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.core.recipe.Recipes;
import com.willfp.eco.core.recipe.parts.EmptyTestableItem;
import com.willfp.eco.core.recipe.parts.GroupedTestableItems;
import com.willfp.eco.core.recipe.parts.TestableStack;
import com.willfp.eco.core.recipe.recipes.CraftingRecipe;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;

@Beta
public final class ShapelessCraftingRecipe
implements CraftingRecipe {
    private final EcoPlugin plugin;
    private final List<TestableItem> parts;
    private final NamespacedKey key;
    private final NamespacedKey displayedKey;
    private final ItemStack output;
    private final String permission;

    private ShapelessCraftingRecipe(@NotNull EcoPlugin plugin, @NotNull String key, @NotNull List<TestableItem> parts, @NotNull ItemStack output, @Nullable String permission) {
        this.plugin = plugin;
        this.parts = parts;
        this.key = plugin.getNamespacedKeyFactory().create(key);
        this.displayedKey = plugin.getNamespacedKeyFactory().create(key + "_displayed");
        this.output = output;
        this.permission = permission;
    }

    @NotNull
    public RecipeTest newTest() {
        return new RecipeTest(this);
    }

    @Override
    public boolean test(@Nullable ItemStack[] matrix) {
        if (matrix == null) {
            return false;
        }
        RecipeTest test = this.newTest();
        for (ItemStack stack : matrix) {
            if (test.matchAndRemove(stack) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void register() {
        Recipes.register(this);
        Bukkit.getServer().removeRecipe(this.getKey());
        Bukkit.getServer().removeRecipe(this.getDisplayedKey());
        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(this.getKey(), this.getOutput());
        for (TestableItem part : this.parts) {
            shapelessRecipe.addIngredient(part.getItem().getType());
        }
        if (Eco.get().getEcoPlugin().getConfigYml().getBool("displayed-recipes")) {
            ShapelessRecipe displayedRecipe = new ShapelessRecipe(this.getDisplayedKey(), this.getOutput());
            for (TestableItem part : this.parts) {
                ArrayList<TestableItem> items = new ArrayList<TestableItem>();
                if (part instanceof GroupedTestableItems) {
                    GroupedTestableItems group = (GroupedTestableItems)part;
                    items.addAll(group.getChildren());
                } else {
                    items.add(part);
                }
                ArrayList<ItemStack> displayedItems = new ArrayList<ItemStack>();
                for (TestableItem testableItem : items) {
                    if (testableItem instanceof TestableStack) {
                        List lore;
                        ItemStack item = testableItem.getItem().clone();
                        ItemMeta meta = item.getItemMeta();
                        assert (meta != null);
                        List list = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                        assert (lore != null);
                        lore.add("");
                        String add = Eco.get().getEcoPlugin().getLangYml().getFormattedString("multiple-in-craft");
                        add = add.replace("%amount%", String.valueOf(item.getAmount()));
                        lore.add(add);
                        meta.setLore(lore);
                        item.setItemMeta(meta);
                        displayedItems.add(item);
                        continue;
                    }
                    displayedItems.add(testableItem.getItem());
                }
                displayedRecipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(displayedItems));
            }
            Bukkit.getServer().addRecipe((Recipe)displayedRecipe);
        }
        Bukkit.getServer().addRecipe((Recipe)shapelessRecipe);
    }

    public EcoPlugin getPlugin() {
        return this.plugin;
    }

    public static Builder builder(@NotNull EcoPlugin plugin, @NotNull String key) {
        return new Builder(plugin, key);
    }

    @Override
    @NotNull
    public List<TestableItem> getParts() {
        return this.parts;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public NamespacedKey getDisplayedKey() {
        return this.displayedKey;
    }

    @Override
    @NotNull
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    @Nullable
    public String getPermission() {
        return this.permission;
    }

    public static final class RecipeTest {
        private final List<TestableItem> remaining;

        private RecipeTest(@NotNull ShapelessCraftingRecipe recipe) {
            this.remaining = new ArrayList<TestableItem>(recipe.getParts());
        }

        @Nullable
        public TestableItem matchAndRemove(@NotNull ItemStack itemStack) {
            if (this.remaining.isEmpty() && !new EmptyTestableItem().matches(itemStack)) {
                return null;
            }
            Optional<TestableItem> match = this.remaining.stream().filter(item -> item.matches(itemStack)).findFirst();
            match.ifPresent(this.remaining::remove);
            return match.orElse(null);
        }
    }

    public static final class Builder {
        private final List<TestableItem> recipeParts = new ArrayList<TestableItem>();
        private ItemStack output = null;
        private String permission = null;
        private final String key;
        private final EcoPlugin plugin;

        private Builder(@NotNull EcoPlugin plugin, @NotNull String key) {
            this.key = key;
            this.plugin = plugin;
        }

        public Builder addRecipePart(@NotNull TestableItem part) {
            this.recipeParts.add(part);
            return this;
        }

        public Builder setOutput(@NotNull ItemStack output) {
            this.output = output;
            return this;
        }

        public Builder setPermission(@Nullable String permission) {
            this.permission = permission;
            return this;
        }

        public boolean isAir() {
            for (TestableItem recipePart : this.recipeParts) {
                if (recipePart == null || recipePart instanceof EmptyTestableItem) continue;
                return false;
            }
            return true;
        }

        public ShapelessCraftingRecipe build() {
            return new ShapelessCraftingRecipe(this.plugin, this.key.toLowerCase(), this.recipeParts, this.output, this.permission);
        }
    }
}

