/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.registry;

import com.willfp.eco.core.registry.Registrable;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;

public class Registry<T extends Registrable>
implements Iterable<T> {
    private static final Pattern ID_PATTERN = Pattern.compile("[a-z0-9_]{1,100}");
    private final Map<String, T> registry = new HashMap<String, T>();
    private boolean isLocked = false;
    @Nullable
    private Object locker = null;

    @NotNull
    public T register(@NotNull T element) {
        if (this.isLocked) {
            throw new IllegalStateException("Cannot add to locked registry! (ID: " + element.getID() + ")");
        }
        Validate.isTrue((boolean)ID_PATTERN.matcher(element.getID()).matches(), (String)("ID must match pattern: " + ID_PATTERN.pattern() + " (was " + element.getID() + ")"));
        this.registry.put(element.getID(), element);
        element.onRegister();
        return element;
    }

    public T remove(@NotNull T element) {
        if (this.isLocked) {
            throw new IllegalStateException("Cannot remove from locked registry! (ID: " + element.getID() + ")");
        }
        element.onRemove();
        this.registry.remove(element.getID());
        return element;
    }

    @Nullable
    public T remove(@NotNull String id2) {
        if (this.isLocked) {
            throw new IllegalStateException("Cannot remove from locked registry! (ID: " + id2 + ")");
        }
        Registrable element = (Registrable)this.registry.get(id2);
        if (element != null) {
            element.onRemove();
        }
        return (T)((Registrable)this.registry.remove(id2));
    }

    @Nullable
    public T get(@NotNull String id2) {
        return (T)((Registrable)this.registry.get(id2));
    }

    public void clear() {
        for (Registrable value : Set.copyOf(this.registry.values())) {
            this.remove(value);
        }
    }

    public Set<T> values() {
        return Set.copyOf(this.registry.values());
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock(@Nullable Object locker) {
        if (this.isLocked && this.locker != locker) {
            throw new IllegalArgumentException("Registry is already locked with a different locker!");
        }
        this.locker = locker;
        this.isLocked = true;
    }

    public void unlock(@Nullable Object locker) {
        if (this.locker != locker) {
            throw new IllegalArgumentException("Cannot unlock registry!");
        }
        this.locker = null;
        this.isLocked = false;
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.values().iterator();
    }

    @NotNull
    public static String tryFitPattern(@NotNull String string) {
        return string.replace(" ", "_").replace(".", "_").replace("-", "_").toLowerCase(Locale.ENGLISH);
    }
}

