/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.sound;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.serialization.ConfigDeserializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;

public record PlayableSound(@NotNull Sound sound, double pitch, double volume) {
    private static final ConfigDeserializer<PlayableSound> DESERIALIZER = new Deserializer();

    public PlayableSound(@NotNull Sound sound, double pitch) {
        this(sound, pitch, 1.0);
    }

    public void playTo(@NotNull Player player) {
        player.playSound(player.getLocation(), this.sound, (float)this.volume, (float)this.pitch);
    }

    public void playAt(@NotNull Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(location, this.sound, (float)this.volume, (float)this.pitch);
    }

    @Nullable
    public static PlayableSound create(@NotNull Config config) {
        return DESERIALIZER.deserialize(config);
    }

    private static final class Deserializer
    implements ConfigDeserializer<PlayableSound> {
        private Deserializer() {
        }

        @Override
        @Nullable
        public PlayableSound deserialize(@NotNull Config config) {
            if (!config.has("sound")) {
                return null;
            }
            try {
                Sound sound = Sound.valueOf((String)config.getString("sound").toUpperCase());
                double pitch = Objects.requireNonNullElse(config.getDoubleOrNull("pitch"), 1.0);
                double volume = Objects.requireNonNullElse(config.getDoubleOrNull("volume"), 1.0);
                return new PlayableSound(sound, pitch, volume);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

