/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.web;

import com.willfp.eco.core.Eco;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;

public class Paste {
    private final String contents;
    private final String host;

    public Paste(@NotNull String contents) {
        this(contents, "https://paste.willfp.com");
    }

    public Paste(@NotNull String contents, @NotNull String host) {
        this.contents = contents;
        this.host = host;
    }

    public void getHastebinToken(@NotNull Consumer<String> callback) {
        Eco.get().getEcoPlugin().getScheduler().runAsync(() -> {
            try {
                byte[] postData = URLEncoder.encode(this.contents, StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8);
                int postDataLength = postData.length;
                String requestURL = this.host + "/documents";
                URL url2 = new URL(requestURL);
                HttpsURLConnection conn = (HttpsURLConnection)url2.openConnection();
                conn.setDoOutput(true);
                conn.setInstanceFollowRedirects(false);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("User-Agent", "eco-Hastebin");
                conn.setRequestProperty("Content-Length", Integer.toString(postDataLength));
                conn.setUseCaches(false);
                DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                wr.write(postData);
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String response = reader.readLine();
                assert (response != null);
                if (response.contains("\"key\"")) {
                    response = response.substring(response.indexOf(":") + 2, response.length() - 2);
                    callback.accept(response);
                }
            }
            catch (IOException e) {
                callback.accept(e.getMessage());
            }
        });
    }

    public static Paste getFromHastebin(@NotNull String token2) {
        return Paste.getFromHastebin(token2, "https://paste.willfp.com");
    }

    public static Paste getFromHastebin(@NotNull String token2, @NotNull String host) {
        try {
            StringBuilder result2 = new StringBuilder();
            URL url2 = new URL(host + "/raw/" + token2);
            HttpURLConnection conn = (HttpURLConnection)url2.openConnection();
            conn.setRequestMethod("GET");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result2.append(line);
                }
            }
            return new Paste(URLDecoder.decode(result2.toString(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getContents() {
        return this.contents;
    }
}

