/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.command;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.command.PluginCommandBase;
import com.willfp.eco.internal.command.DelegatedBukkitCommand;
import com.willfp.eco.internal.command.HandledCommand;
import com.willfp.eco.internal.command.HandledCommandKt;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/willfp/eco/internal/command/EcoPluginCommand;", "Lcom/willfp/eco/internal/command/HandledCommand;", "Lcom/willfp/eco/core/command/PluginCommandBase;", "parentDelegate", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "name", "", "permission", "playersOnly", "", "(Lcom/willfp/eco/core/command/PluginCommandBase;Lcom/willfp/eco/core/EcoPlugin;Ljava/lang/String;Ljava/lang/String;Z)V", "getAliases", "", "getDescription", "register", "", "unregister", "core-backend"})
public final class EcoPluginCommand
extends HandledCommand
implements PluginCommandBase {
    @NotNull
    private final PluginCommandBase parentDelegate;

    public EcoPluginCommand(@NotNull PluginCommandBase parentDelegate, @NotNull EcoPlugin plugin, @NotNull String name, @NotNull String permission, boolean playersOnly) {
        Intrinsics.checkNotNullParameter(parentDelegate, "parentDelegate");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(permission, "permission");
        super(parentDelegate, plugin, name, permission, playersOnly);
        this.parentDelegate = parentDelegate;
    }

    @Override
    public void register() {
        List<String> knownAliases;
        PluginCommand command2 = Bukkit.getPluginCommand((String)this.getName());
        Object object = command2;
        if ((object == null || (object = object.getDescription()) == null) && (object = this.getDescription()) == null) {
            object = "";
        }
        Object knownDescription = object;
        PluginCommand pluginCommand = command2;
        List<String> list = pluginCommand != null ? pluginCommand.getAliases() : null;
        if (list == null) {
            list = knownAliases = this.getAliases();
        }
        if (command2 == null) {
            this.unregister();
            CommandMap commandMap = HandledCommandKt.getCommandMap();
            String string = this.getPlugin().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            commandMap.register(string2, (Command)new DelegatedBukkitCommand(this));
        } else {
            command2.setExecutor((CommandExecutor)this);
            command2.setTabCompleter((TabCompleter)this);
            command2.setDescription((String)knownDescription);
            command2.setAliases(knownAliases);
        }
        Eco.get().syncCommands();
    }

    @Override
    public void unregister() {
        Command command2 = HandledCommandKt.getCommandMap().getCommand(this.getName());
        if (command2 != null) {
            command2.unregister(HandledCommandKt.getCommandMap());
        }
        Eco.get().unregisterCommand(this);
        Eco.get().syncCommands();
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        List<String> list = this.parentDelegate.getAliases();
        Intrinsics.checkNotNullExpressionValue(list, "getAliases(...)");
        return list;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.parentDelegate.getDescription();
    }
}

