/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.config;

import com.willfp.eco.core.PluginLike;
import com.willfp.eco.core.config.ConfigType;
import com.willfp.eco.core.config.interfaces.LoadableConfig;
import com.willfp.eco.internal.config.ConfigUtilsKt;
import com.willfp.eco.internal.config.EcoConfig;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\u0019\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0006H\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0010J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0004J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0006\u0010#\u001a\u00020\u0018J\b\u0010$\u001a\u00020\u0018H\u0016J\b\u0010%\u001a\u00020\u0018H\u0016J\u001b\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00062\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020\u0006H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/willfp/eco/internal/config/EcoLoadableConfig;", "Lcom/willfp/eco/internal/config/EcoConfig;", "Lcom/willfp/eco/core/config/interfaces/LoadableConfig;", "type", "Lcom/willfp/eco/core/config/ConfigType;", "configName", "", "plugin", "Lcom/willfp/eco/core/PluginLike;", "subDirectoryPath", "source", "Ljava/lang/Class;", "requiresChangesToSave", "", "(Lcom/willfp/eco/core/config/ConfigType;Ljava/lang/String;Lcom/willfp/eco/core/PluginLike;Ljava/lang/String;Ljava/lang/Class;Z)V", "configFile", "Ljava/io/File;", "hasChanged", "header", "", "name", "getSource", "()Ljava/lang/Class;", "addToHandler", "", "createFile", "getConfigFile", "getName", "getResourcePath", "init", "file", "reader", "Ljava/io/Reader;", "makeHeader", "contents", "reloadFromFile", "save", "saveAsync", "set", "path", "obj", "", "toPlaintext", "core-backend"})
@SourceDebugExtension(value={"SMAP\nEcoLoadableConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoLoadableConfig.kt\ncom/willfp/eco/internal/config/EcoLoadableConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
public class EcoLoadableConfig
extends EcoConfig
implements LoadableConfig {
    @NotNull
    private final PluginLike plugin;
    @NotNull
    private final String subDirectoryPath;
    @NotNull
    private final Class<?> source;
    private final boolean requiresChangesToSave;
    @NotNull
    private final File configFile;
    @NotNull
    private final String name;
    private boolean hasChanged;
    @NotNull
    private final List<String> header;

    public EcoLoadableConfig(@NotNull ConfigType type2, @NotNull String configName, @NotNull PluginLike plugin, @NotNull String subDirectoryPath, @NotNull Class<?> source, boolean requiresChangesToSave) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(configName, "configName");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(subDirectoryPath, "subDirectoryPath");
        Intrinsics.checkNotNullParameter(source, "source");
        super(type2);
        this.plugin = plugin;
        this.subDirectoryPath = subDirectoryPath;
        this.source = source;
        this.requiresChangesToSave = requiresChangesToSave;
        this.name = configName + "." + type2.getExtension();
        this.header = new ArrayList();
        File directory = new File(this.plugin.getDataFolder(), this.subDirectoryPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!new File(directory, this.name).exists()) {
            this.createFile();
        }
        this.configFile = new File(directory, this.name);
        this.init(this.configFile);
        this.addToHandler(this.plugin);
    }

    @NotNull
    public final Class<?> getSource() {
        return this.source;
    }

    public final void reloadFromFile() {
        block2: {
            Object object;
            Object object2 = this;
            try {
                EcoLoadableConfig $this$reloadFromFile_u24lambda_u240 = object2;
                boolean bl = false;
                $this$reloadFromFile_u24lambda_u240.init($this$reloadFromFile_u24lambda_u240.configFile);
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            ((Throwable)it).printStackTrace();
        }
    }

    @Override
    public final void createFile() {
        InputStream inputStream = this.source.getResourceAsStream(this.getResourcePath());
        Intrinsics.checkNotNull(inputStream);
        InputStream inputStream2 = inputStream;
        File outFile = new File(this.plugin.getDataFolder(), this.getResourcePath());
        int lastIndex = StringsKt.lastIndexOf$default((CharSequence)this.getResourcePath(), '/', 0, false, 6, null);
        File file = this.plugin.getDataFolder();
        String string = this.getResourcePath().substring(0, RangesKt.coerceAtLeast(lastIndex, 0));
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        File outDir = new File(file, string);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (!outFile.exists()) {
            OutputStream out = new FileOutputStream(outFile);
            ByteStreamsKt.copyTo$default(inputStream2, out, 0, 2, null);
            out.close();
            inputStream2.close();
        }
    }

    @Override
    @NotNull
    public String getResourcePath() {
        String resourcePath = ((CharSequence)this.subDirectoryPath).length() == 0 ? this.name : this.subDirectoryPath + this.name;
        return "/" + resourcePath;
    }

    @Override
    public void save() throws IOException {
        if (this.requiresChangesToSave && !this.hasChanged) {
            return;
        }
        if (this.configFile.delete()) {
            Path path = this.configFile.toPath();
            OpenOption[] openOptionArray = this.toPlaintext();
            byte[] byArray = openOptionArray.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Files.write(path, byArray, openOptionArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAsync() {
        Object object = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE};
        object = AsynchronousFileChannel.open(this.configFile.toPath(), object);
        Throwable throwable = null;
        try {
            AsynchronousFileChannel channel = (AsynchronousFileChannel)object;
            boolean bl = false;
            byte[] byArray = this.toPlaintext().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            Future<Integer> future = channel.write(ByteBuffer.wrap(byArray), 0L);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    private final void makeHeader(String contents) {
        this.header.clear();
        if (this.getType() == ConfigType.YAML) {
            for (String line : StringsKt.lines(contents)) {
                if (!StringsKt.startsWith$default(line, "#", false, 2, null)) break;
                this.header.add(line);
            }
        }
    }

    protected final void init(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        String string = ConfigUtilsKt.readToString(reader);
        this.makeHeader(string);
        super.init(ConfigUtilsKt.toMap(this.getType(), string), MapsKt.emptyMap());
    }

    public final void init(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.init(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
    }

    @Override
    @NotNull
    public String toPlaintext() {
        StringBuilder contents = new StringBuilder();
        if (this.getType() == ConfigType.YAML) {
            for (String s2 : this.header) {
                contents.append(s2 + "\n");
            }
            if (!((Collection)this.header).isEmpty()) {
                contents.append("\n");
            }
        }
        for (String line : StringsKt.lines(super.toPlaintext())) {
            if (StringsKt.startsWith$default(line, "#", false, 2, null)) continue;
            contents.append(line + "\n");
        }
        String string = contents.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public void set(@NotNull String path, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.hasChanged = true;
        super.set(path, obj);
    }

    private final void addToHandler(PluginLike plugin) {
        plugin.getConfigHandler().addConfig(this);
    }
}

