/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.drops;

import com.willfp.eco.core.Prerequisite;
import com.willfp.eco.core.drops.DropQueue;
import com.willfp.eco.core.events.DropQueuePushEvent;
import com.willfp.eco.core.integrations.antigrief.AntigriefManager;
import com.willfp.eco.internal.drops.EcoDropQueue;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.TelekinesisUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\rH\u0016J\u0016\u0010 \u001a\u00020\u00012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"H\u0016J\u0010\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0019H\u0016J\b\u0010%\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lcom/willfp/eco/internal/drops/EcoDropQueue;", "Lcom/willfp/eco/core/drops/DropQueue;", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;)V", "hasTelekinesis", "", "getHasTelekinesis", "()Z", "setHasTelekinesis", "(Z)V", "items", "", "Lorg/bukkit/inventory/ItemStack;", "getItems", "()Ljava/util/List;", "location", "Lorg/bukkit/Location;", "getLocation", "()Lorg/bukkit/Location;", "setLocation", "(Lorg/bukkit/Location;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "xp", "", "getXp", "()I", "setXp", "(I)V", "addItem", "item", "addItems", "itemStacks", "", "addXP", "amount", "forceTelekinesis", "push", "", "core-backend"})
@SourceDebugExtension(value={"SMAP\nEcoDropQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoDropQueue.kt\ncom/willfp/eco/internal/drops/EcoDropQueue\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,103:1\n37#2,2:104\n*S KotlinDebug\n*F\n+ 1 EcoDropQueue.kt\ncom/willfp/eco/internal/drops/EcoDropQueue\n*L\n71#1:104,2\n*E\n"})
public class EcoDropQueue
extends DropQueue {
    @NotNull
    private final Player player;
    @NotNull
    private final List<ItemStack> items;
    private int xp;
    @NotNull
    private Location location;
    private boolean hasTelekinesis;

    public EcoDropQueue(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.player = player;
        this.items = new ArrayList();
        Location location = this.player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.location = location;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final List<ItemStack> getItems() {
        return this.items;
    }

    public final int getXp() {
        return this.xp;
    }

    public final void setXp(int n) {
        this.xp = n;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    public final void setLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "<set-?>");
        this.location = location;
    }

    public final boolean getHasTelekinesis() {
        return this.hasTelekinesis;
    }

    public final void setHasTelekinesis(boolean bl) {
        this.hasTelekinesis = bl;
    }

    @Override
    @NotNull
    public DropQueue addItem(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        this.items.add(item);
        return this;
    }

    @NotNull
    public DropQueue addItems(@NotNull Collection<? extends ItemStack> itemStacks) {
        Intrinsics.checkNotNullParameter(itemStacks, "itemStacks");
        this.items.addAll(itemStacks);
        return this;
    }

    @Override
    @NotNull
    public DropQueue addXP(int amount) {
        this.xp += amount;
        return this;
    }

    @Override
    @NotNull
    public DropQueue setLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        this.location = location;
        return this;
    }

    @Override
    @NotNull
    public DropQueue forceTelekinesis() {
        this.hasTelekinesis = true;
        return this;
    }

    @Override
    public void push() {
        if (!this.hasTelekinesis) {
            this.hasTelekinesis = TelekinesisUtils.testPlayer(this.player);
        }
        if (this.hasTelekinesis && !AntigriefManager.canPickupItem(this.player, this.location)) {
            this.hasTelekinesis = false;
        }
        DropQueuePushEvent pushEvent = new DropQueuePushEvent(this.player, (Collection<? extends ItemStack>)this.items, this.location, this.xp, this.hasTelekinesis);
        Bukkit.getServer().getPluginManager().callEvent((Event)pushEvent);
        if (pushEvent.isCancelled()) {
            return;
        }
        World world = this.location.getWorld();
        Intrinsics.checkNotNull(world);
        World world2 = world;
        Location location = this.location.add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        this.location = location;
        this.items.removeIf(arg_0 -> EcoDropQueue.push$lambda$0(push.1.INSTANCE, arg_0));
        if (this.items.isEmpty()) {
            return;
        }
        if (this.hasTelekinesis) {
            Collection $this$toTypedArray$iv = this.items;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ItemStack[] itemStackArray = thisCollection$iv.toArray(new ItemStack[0]);
            HashMap hashMap = this.player.getInventory().addItem(Arrays.copyOf(itemStackArray, itemStackArray.length));
            Intrinsics.checkNotNullExpressionValue(hashMap, "addItem(...)");
            HashMap leftover = hashMap;
            Iterator iterator2 = leftover.values().iterator();
            while (iterator2.hasNext()) {
                ItemStack drop2;
                ItemStack itemStack = drop2 = (ItemStack)iterator2.next();
                Intrinsics.checkNotNull(itemStack);
                world2.dropItem(this.location, itemStack).setVelocity(new Vector());
            }
            if (this.xp > 0) {
                if (Prerequisite.HAS_PAPER.isMet()) {
                    this.player.giveExp(this.xp, true);
                } else {
                    Entity entity = world2.spawnEntity(this.player.getLocation().add(0.0, 0.2, 0.0), EntityType.EXPERIENCE_ORB);
                    Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.ExperienceOrb");
                    ExperienceOrb orb = (ExperienceOrb)entity;
                    orb.setVelocity(new Vector(0, 0, 0));
                    orb.setExperience(this.xp);
                }
            }
        } else {
            for (ItemStack drop3 : this.items) {
                world2.dropItem(this.location, drop3).setVelocity(new Vector());
            }
            if (this.xp > 0) {
                Entity entity = world2.spawnEntity(this.location, EntityType.EXPERIENCE_ORB);
                Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.ExperienceOrb");
                ExperienceOrb orb = (ExperienceOrb)entity;
                orb.setExperience(this.xp);
            }
        }
    }

    private static final boolean push$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

