/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.entities;

import com.willfp.eco.core.entities.args.EntityArgParseResult;
import com.willfp.eco.core.entities.args.EntityArgParser;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/internal/entities/EntityArgParserEquipment;", "Lcom/willfp/eco/core/entities/args/EntityArgParser;", "()V", "parseArguments", "Lcom/willfp/eco/core/entities/args/EntityArgParseResult;", "args", "", "", "([Ljava/lang/String;)Lcom/willfp/eco/core/entities/args/EntityArgParseResult;", "core-backend"})
public final class EntityArgParserEquipment
implements EntityArgParser {
    @NotNull
    public static final EntityArgParserEquipment INSTANCE = new EntityArgParserEquipment();

    private EntityArgParserEquipment() {
    }

    @Override
    @Nullable
    public EntityArgParseResult parseArguments(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Map equipment = new LinkedHashMap();
        for (String arg : args2) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                TestableItem testableItem;
                String string = arg.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                String string2 = slot.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                if (!StringsKt.startsWith$default(string, string2 + ":", false, 2, null)) continue;
                Map map2 = equipment;
                String string3 = arg.substring(slot.name().length() + 1, arg.length());
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                Intrinsics.checkNotNullExpressionValue(Items.lookup(string3), "lookup(...)");
                map2.put(slot, testableItem);
            }
        }
        if (equipment.isEmpty()) {
            return null;
        }
        return new EntityArgParseResult(arg_0 -> EntityArgParserEquipment.parseArguments$lambda$0(equipment, arg_0), arg_0 -> EntityArgParserEquipment.parseArguments$lambda$1(equipment, arg_0));
    }

    private static final boolean parseArguments$lambda$0(Map $equipment, Entity it) {
        Intrinsics.checkNotNullParameter($equipment, "$equipment");
        if (!(it instanceof LivingEntity)) {
            return false;
        }
        EntityEquipment entityEquipment = ((LivingEntity)it).getEquipment();
        if (entityEquipment == null) {
            return false;
        }
        EntityEquipment entityEquipment2 = entityEquipment;
        for (Map.Entry entry : $equipment.entrySet()) {
            EquipmentSlot slot = (EquipmentSlot)entry.getKey();
            TestableItem item = (TestableItem)entry.getValue();
            if (item.matches(entityEquipment2.getItem(slot))) continue;
            return false;
        }
        return true;
    }

    private static final void parseArguments$lambda$1(Map $equipment, Entity it) {
        Intrinsics.checkNotNullParameter($equipment, "$equipment");
        if (!(it instanceof LivingEntity)) {
            return;
        }
        EntityEquipment entityEquipment = ((LivingEntity)it).getEquipment();
        if (entityEquipment == null) {
            return;
        }
        EntityEquipment entityEquipment2 = entityEquipment;
        for (Map.Entry entry : $equipment.entrySet()) {
            EquipmentSlot slot = (EquipmentSlot)entry.getKey();
            TestableItem item = (TestableItem)entry.getValue();
            entityEquipment2.setItem(slot, item.getItem(), false);
        }
    }
}

