/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.extensions;

import com.google.common.collect.ImmutableSet;
import com.willfp.eco.core.Eco;
import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.config.ConfigExtensions;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.extensions.Extension;
import com.willfp.eco.core.extensions.ExtensionLoadException;
import com.willfp.eco.core.extensions.ExtensionLoader;
import com.willfp.eco.core.extensions.ExtensionMetadata;
import com.willfp.eco.core.extensions.MalformedExtensionException;
import com.willfp.eco.core.version.Version;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/willfp/eco/internal/extensions/EcoExtensionLoader;", "Lcom/willfp/eco/core/extensions/ExtensionLoader;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "extensions", "", "Lcom/willfp/eco/core/extensions/Extension;", "Ljava/net/URLClassLoader;", "getLoadedExtensions", "", "loadExtension", "", "extensionJar", "Ljava/io/File;", "loadExtensions", "unloadExtensions", "core-backend"})
@SourceDebugExtension(value={"SMAP\nEcoExtensionLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoExtensionLoader.kt\ncom/willfp/eco/internal/extensions/EcoExtensionLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1#2:114\n1855#3,2:115\n*S KotlinDebug\n*F\n+ 1 EcoExtensionLoader.kt\ncom/willfp/eco/internal/extensions/EcoExtensionLoader\n*L\n105#1:115,2\n*E\n"})
public final class EcoExtensionLoader
implements ExtensionLoader {
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private final Map<Extension, URLClassLoader> extensions;

    public EcoExtensionLoader(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.extensions = new LinkedHashMap();
    }

    @Override
    public void loadExtensions() {
        File dir = new File(this.plugin.getDataFolder(), "/extensions");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File[] fileArray = dir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File extensionJar : fileArray) {
            Object object;
            if (!extensionJar.isFile()) continue;
            Object object2 = this;
            try {
                EcoExtensionLoader $this$loadExtensions_u24lambda_u240 = object2;
                boolean bl = false;
                Intrinsics.checkNotNull(extensionJar);
                $this$loadExtensions_u24lambda_u240.loadExtension(extensionJar);
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) continue;
            Object it = object = throwable;
            boolean bl = false;
            Logger logger = this.plugin.getLogger();
            String string = extensionJar.getName();
            String string2 = ((Throwable)it).getMessage();
            if (string2 == null) {
                string2 = "Unknown error";
            }
            logger.warning(string + " caused an error: " + string2);
            if (!Eco.get().getEcoPlugin().getConfigYml().getBool("log-full-extension-errors")) continue;
            ((Throwable)it).printStackTrace();
        }
    }

    private final void loadExtension(File extensionJar) throws MalformedExtensionException {
        URL url2 = extensionJar.toURI().toURL();
        URL[] uRLArray = new URL[]{url2};
        URLClassLoader classLoader = new URLClassLoader(uRLArray, this.plugin.getClass().getClassLoader());
        InputStream inputStream = classLoader.getResourceAsStream("extension.yml");
        if (inputStream == null) {
            throw new MalformedExtensionException("No extension.yml found in " + extensionJar.getName());
        }
        InputStream ymlIn = inputStream;
        Config extensionYml = ConfigExtensions.toConfig((ConfigurationSection)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(ymlIn)));
        String mainClass = extensionYml.getStringOrNull("main");
        Object name = extensionYml.getStringOrNull("name");
        String version2 = extensionYml.getStringOrNull("version");
        String author = extensionYml.getStringOrNull("author");
        String string = extensionYml.getStringOrNull("plugin-version");
        if (string == null) {
            string = "0.0.0";
        }
        Version pluginVersion = new Version(string);
        String pluginName = extensionYml.getStringOrNull("plugin");
        if (pluginName != null && !StringsKt.equals(pluginName, this.plugin.getDescription().getName(), true)) {
            throw new ExtensionLoadException(extensionJar.getName() + " is only compatible with " + pluginName + "!");
        }
        if (mainClass == null) {
            throw new MalformedExtensionException("Invalid extension.yml found in " + extensionJar.getName());
        }
        if (name == null) {
            this.plugin.getLogger().warning(extensionJar.getName() + " doesn't have a name!");
            name = "Unnamed Extension " + extensionJar.getName();
        }
        if (version2 == null) {
            this.plugin.getLogger().warning(extensionJar.getName() + " doesn't have a version!");
            version2 = "1.0.0";
        }
        if (author == null) {
            this.plugin.getLogger().warning(extensionJar.getName() + " doesn't have an author!");
            author = "Unnamed Author";
        }
        if (new Version(this.plugin.getDescription().getVersion()).compareTo(pluginVersion) < 0) {
            throw new ExtensionLoadException("Plugin version is too low for " + extensionJar.getName() + "!");
        }
        ExtensionMetadata metadata2 = new ExtensionMetadata(version2, (String)name, author, extensionJar, pluginVersion);
        Class<?> clazz = classLoader.loadClass(mainClass);
        Intrinsics.checkNotNullExpressionValue(clazz, "loadClass(...)");
        Class<?> cls = clazz;
        Object[] objectArray = new Class[]{EcoPlugin.class};
        Constructor<?> constructor = cls.getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{this.plugin};
        Object obj = constructor.newInstance(objectArray);
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type com.willfp.eco.core.extensions.Extension");
        Extension extension = (Extension)obj;
        extension.setMetadata(metadata2);
        extension.enable();
        this.extensions.put(extension, classLoader);
    }

    @Override
    @NotNull
    public Set<Extension> getLoadedExtensions() {
        ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.extensions.keySet());
        Intrinsics.checkNotNullExpressionValue(immutableSet, "copyOf(...)");
        return (Set)immutableSet;
    }

    @Override
    public void unloadExtensions() {
        Iterable $this$forEach$iv = this.extensions.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Extension e = (Extension)element$iv;
            boolean bl = false;
            e.disable();
        }
        for (URLClassLoader urlClassLoader : this.extensions.values()) {
            urlClassLoader.close();
        }
        this.extensions.clear();
    }
}

