/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.gui.menu;

import com.willfp.eco.core.gui.menu.CloseHandler;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.menu.MenuEvent;
import com.willfp.eco.core.gui.menu.MenuEventHandler;
import com.willfp.eco.core.gui.menu.OpenHandler;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.internal.gui.menu.EcoMenuKt;
import com.willfp.eco.internal.gui.menu.GUIPosition;
import com.willfp.eco.internal.gui.menu.LayeredComponents;
import com.willfp.eco.internal.gui.menu.MenuHandler;
import com.willfp.eco.internal.gui.menu.RenderedInventory;
import com.willfp.eco.internal.gui.menu.RenderedInventoryKt;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u001e\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\r0\n\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n\u0012\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\n\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\"\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\n2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\"\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010$\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J \u0010%\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u001e\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010(0'2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J)\u0010&\u001a\u0004\u0018\u0001H)\"\b\b\u0000\u0010)*\u00020(2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\bH\u0016J\u000e\u0010-\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020.J\u0010\u0010/\u001a\u0002002\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u00101\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0018\u00102\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\bH\u0016J\u000e\u00103\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000eJ\"\u00104\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\b2\b\u00105\u001a\u0004\u0018\u00010(H\u0016J,\u00106\u001a\u00020\u000f\"\b\b\u0000\u0010)*\u00020\u001a*\b\u0012\u0004\u0012\u0002H)0\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/willfp/eco/internal/gui/menu/EcoMenu;", "Lcom/willfp/eco/core/gui/menu/Menu;", "rows", "", "columns", "components", "Lcom/willfp/eco/internal/gui/menu/LayeredComponents;", "title", "", "onClose", "", "Lcom/willfp/eco/core/gui/menu/CloseHandler;", "onRender", "Lkotlin/Function2;", "Lorg/bukkit/entity/Player;", "", "onOpen", "Lcom/willfp/eco/core/gui/menu/OpenHandler;", "menuEventHandlers", "Lcom/willfp/eco/core/gui/menu/MenuEventHandler;", "allowsChangingHeldItem", "", "(IILcom/willfp/eco/internal/gui/menu/LayeredComponents;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Z)V", "callEvent", "player", "event", "Lcom/willfp/eco/core/gui/menu/MenuEvent;", "clearState", "getCaptiveItem", "Lorg/bukkit/inventory/ItemStack;", "row", "column", "getCaptiveItems", "getColumns", "getPossiblyReactiveSlot", "Lcom/willfp/eco/core/gui/slot/Slot;", "getRows", "getSlot", "getState", "", "", "T", "key", "(Lorg/bukkit/entity/Player;Ljava/lang/String;)Ljava/lang/Object;", "getTitle", "handleClose", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "open", "Lorg/bukkit/inventory/Inventory;", "refresh", "removeState", "runOnRender", "setState", "value", "handle", "core-backend"})
@SourceDebugExtension(value={"SMAP\nEcoMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoMenu.kt\ncom/willfp/eco/internal/gui/menu/EcoMenu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1855#2,2:164\n1855#2,2:166\n1855#2,2:168\n*S KotlinDebug\n*F\n+ 1 EcoMenu.kt\ncom/willfp/eco/internal/gui/menu/EcoMenu\n*L\n63#1:164,2\n78#1:166,2\n148#1:168,2\n*E\n"})
public final class EcoMenu
implements Menu {
    private final int rows;
    private final int columns;
    @NotNull
    private final LayeredComponents components;
    @NotNull
    private final String title;
    @NotNull
    private final List<CloseHandler> onClose;
    @NotNull
    private final List<Function2<Player, Menu, Unit>> onRender;
    @NotNull
    private final List<OpenHandler> onOpen;
    @NotNull
    private final List<MenuEventHandler<?>> menuEventHandlers;
    private final boolean allowsChangingHeldItem;

    public EcoMenu(int rows, int columns2, @NotNull LayeredComponents components, @NotNull String title, @NotNull List<? extends CloseHandler> onClose, @NotNull List<? extends Function2<? super Player, ? super Menu, Unit>> onRender2, @NotNull List<? extends OpenHandler> onOpen, @NotNull List<? extends MenuEventHandler<?>> menuEventHandlers, boolean allowsChangingHeldItem) {
        Intrinsics.checkNotNullParameter(components, "components");
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(onClose, "onClose");
        Intrinsics.checkNotNullParameter(onRender2, "onRender");
        Intrinsics.checkNotNullParameter(onOpen, "onOpen");
        Intrinsics.checkNotNullParameter(menuEventHandlers, "menuEventHandlers");
        this.rows = rows;
        this.columns = columns2;
        this.components = components;
        this.title = title;
        this.onClose = onClose;
        this.onRender = onRender2;
        this.onOpen = onOpen;
        this.menuEventHandlers = menuEventHandlers;
        this.allowsChangingHeldItem = allowsChangingHeldItem;
    }

    private final Slot getPossiblyReactiveSlot(int row2, int column, Player player) {
        if (row2 < 1 || row2 > this.rows || column < 1 || column > this.columns) {
            return EcoMenuKt.getEmptyFillerSlot();
        }
        return this.components.getSlotAt(row2, column, player, this);
    }

    @Override
    @NotNull
    public Slot getSlot(int row2, int column) {
        return this.getPossiblyReactiveSlot(row2, column, null);
    }

    @Override
    @NotNull
    public Slot getSlot(int row2, int column, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.getPossiblyReactiveSlot(row2, column, player);
    }

    @Override
    @NotNull
    public Inventory open(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Inventory inventory = this.columns == 9 ? Bukkit.createInventory(null, (int)(this.rows * this.columns), (String)this.title) : Bukkit.createInventory(null, (InventoryType)InventoryType.DISPENSER, (String)this.title);
        Intrinsics.checkNotNull(inventory);
        Inventory inventory2 = inventory;
        RenderedInventory rendered = MenuHandler.INSTANCE.registerInventory(inventory2, this, player);
        RenderedInventoryKt.forceRenderedInventory(player, rendered);
        rendered.renderDefaultCaptiveItems();
        Iterable $this$forEach$iv = this.onOpen;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenHandler it = (OpenHandler)element$iv;
            boolean bl = false;
            it.handle(player, this);
        }
        rendered.render();
        player.openInventory(inventory2);
        RenderedInventoryKt.removeForcedRenderedInventory(player);
        return inventory2;
    }

    public final void handleClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Iterable $this$forEach$iv = this.onClose;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloseHandler it = (CloseHandler)element$iv;
            boolean bl = false;
            it.handle(event, this);
        }
        Inventory inventory = event.getInventory();
        Intrinsics.checkNotNullExpressionValue(inventory, "getInventory(...)");
        MenuHandler.INSTANCE.unregisterInventory(inventory);
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public List<ItemStack> getCaptiveItems(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
        if (renderedInventory == null) {
            return CollectionsKt.emptyList();
        }
        RenderedInventory inventory = renderedInventory;
        return CollectionsKt.toList((Iterable)inventory.getCaptiveItems().values());
    }

    @Override
    @Nullable
    public ItemStack getCaptiveItem(@NotNull Player player, int row2, int column) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (row2 < 1 || row2 > this.rows || column < 1 || column > this.columns) {
            return null;
        }
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
        if (renderedInventory == null) {
            return null;
        }
        RenderedInventory inventory = renderedInventory;
        return inventory.getCaptiveItems().get(new GUIPosition(row2, column));
    }

    @Override
    public void callEvent(@NotNull Player player, @NotNull MenuEvent event) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(event, "event");
        for (MenuEventHandler<?> handler : this.menuEventHandlers) {
            if (!handler.canHandleEvent(event)) continue;
            this.handle(handler, event, player);
        }
    }

    private final <T extends MenuEvent> void handle(MenuEventHandler<T> $this$handle, MenuEvent event, Player player) {
        Menu menu = this;
        Intrinsics.checkNotNull(event, "null cannot be cast to non-null type T of com.willfp.eco.internal.gui.menu.EcoMenu.handle");
        $this$handle.handle(player, menu, event);
    }

    @Override
    public void setState(@NotNull Player player, @NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(key, "key");
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
        if (renderedInventory == null) {
            return;
        }
        RenderedInventory inventory = renderedInventory;
        inventory.getState().put(key, value);
    }

    @Override
    @NotNull
    public Map<String, Object> getState(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
        if (renderedInventory == null) {
            return MapsKt.emptyMap();
        }
        RenderedInventory inventory = renderedInventory;
        return MapsKt.toMap(inventory.getState());
    }

    @Override
    @Nullable
    public <T> T getState(@NotNull Player player, @NotNull String key) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(key, "key");
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
        if (renderedInventory == null) {
            return null;
        }
        RenderedInventory inventory = renderedInventory;
        Object object = inventory.getState().get(key);
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    @Override
    public void removeState(@NotNull Player player, @NotNull String key) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(key, "key");
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
        if (renderedInventory == null) {
            return;
        }
        RenderedInventory inventory = renderedInventory;
        inventory.getState().remove(key);
    }

    @Override
    public void clearState(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
        if (renderedInventory == null) {
            return;
        }
        RenderedInventory inventory = renderedInventory;
        inventory.getState().clear();
    }

    @Override
    public void refresh(@NotNull Player player) {
        block0: {
            Intrinsics.checkNotNullParameter(player, "player");
            RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
            if (renderedInventory == null) break block0;
            renderedInventory.render();
        }
    }

    @Override
    public boolean allowsChangingHeldItem() {
        return this.allowsChangingHeldItem;
    }

    public final void runOnRender(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Iterable $this$forEach$iv = this.onRender;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke(player, this);
        }
    }
}

