/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.gui.menu;

import com.willfp.eco.core.gui.GUIComponent;
import com.willfp.eco.core.gui.menu.CloseHandler;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.menu.MenuBuilder;
import com.willfp.eco.core.gui.menu.MenuEventHandler;
import com.willfp.eco.core.gui.menu.MenuLayer;
import com.willfp.eco.core.gui.menu.OpenHandler;
import com.willfp.eco.internal.gui.menu.EcoMenu;
import com.willfp.eco.internal.gui.menu.EcoMenuBuilder;
import com.willfp.eco.internal.gui.menu.GUIPosition;
import com.willfp.eco.internal.gui.menu.LayeredComponents;
import com.willfp.eco.internal.gui.menu.OffsetComponent;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J(\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020\u0001H\u0016J\b\u0010#\u001a\u00020\u0012H\u0016J\b\u0010$\u001a\u00020\u0003H\u0016J\b\u0010%\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\u0016\u0010'\u001a\u00020\u00012\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010)H\u0016J\u0016\u0010\u0010\u001a\u00020\u00012\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120)H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u0015H\u0016J\u0014\u0010+\u001a\u00020\u00012\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00012\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00120,H\u0016J\u0010\u0010-\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a \u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0018\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00190\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/willfp/eco/internal/gui/menu/EcoMenuBuilder;", "Lcom/willfp/eco/core/gui/menu/MenuBuilder;", "rows", "", "columns", "(II)V", "allowsChangingHeldItem", "", "components", "", "Lcom/willfp/eco/core/gui/menu/MenuLayer;", "Lcom/willfp/eco/internal/gui/menu/GUIPosition;", "", "Lcom/willfp/eco/core/gui/GUIComponent;", "menuEventHandlers", "Lcom/willfp/eco/core/gui/menu/MenuEventHandler;", "onBuild", "Lkotlin/Function1;", "Lcom/willfp/eco/core/gui/menu/Menu;", "", "onClose", "Lcom/willfp/eco/core/gui/menu/CloseHandler;", "onOpen", "Lcom/willfp/eco/core/gui/menu/OpenHandler;", "onRender", "Lkotlin/Function2;", "Lorg/bukkit/entity/Player;", "title", "", "addComponent", "layer", "row", "column", "component", "allowChangingHeldItem", "build", "getColumns", "getRows", "getTitle", "modfiy", "modifier", "Ljava/util/function/Consumer;", "action", "onEvent", "Ljava/util/function/BiConsumer;", "setTitle", "core-backend"})
@SourceDebugExtension(value={"SMAP\nEcoMenuBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoMenuBuilder.kt\ncom/willfp/eco/internal/gui/menu/EcoMenuBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1#2:149\n1855#3,2:150\n*S KotlinDebug\n*F\n+ 1 EcoMenuBuilder.kt\ncom/willfp/eco/internal/gui/menu/EcoMenuBuilder\n*L\n143#1:150,2\n*E\n"})
public final class EcoMenuBuilder
implements MenuBuilder {
    private final int rows;
    private final int columns;
    @NotNull
    private String title;
    @NotNull
    private final Map<MenuLayer, Map<GUIPosition, List<GUIComponent>>> components;
    @NotNull
    private final List<CloseHandler> onClose;
    @NotNull
    private final List<OpenHandler> onOpen;
    @NotNull
    private final List<Function2<Player, Menu, Unit>> onRender;
    @NotNull
    private final List<MenuEventHandler<?>> menuEventHandlers;
    @NotNull
    private final List<Function1<Menu, Unit>> onBuild;
    private boolean allowsChangingHeldItem;

    public EcoMenuBuilder(int rows, int columns2) {
        this.rows = rows;
        this.columns = columns2;
        this.title = "Menu";
        this.components = new LinkedHashMap();
        this.onClose = new ArrayList();
        this.onOpen = new ArrayList();
        this.onRender = new ArrayList();
        this.menuEventHandlers = new ArrayList();
        this.onBuild = new ArrayList();
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    @NotNull
    public MenuBuilder setTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter(title, "title");
        String string = StringUtils.format(title);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        this.title = string;
        return this;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public MenuBuilder addComponent(@NotNull MenuLayer layer, int row2, int column, @NotNull GUIComponent component) {
        Intrinsics.checkNotNullParameter((Object)layer, "layer");
        Intrinsics.checkNotNullParameter(component, "component");
        if (!(1 <= row2 ? row2 <= this.rows : false)) {
            boolean $i$a$-require-EcoMenuBuilder$addComponent$52 = false;
            String $i$a$-require-EcoMenuBuilder$addComponent$52 = "Invalid row number!";
            throw new IllegalArgumentException($i$a$-require-EcoMenuBuilder$addComponent$52.toString());
        }
        if (!(1 <= column ? column <= this.columns : false)) {
            boolean $i$a$-require-EcoMenuBuilder$addComponent$62 = false;
            String $i$a$-require-EcoMenuBuilder$addComponent$62 = "Invalid column number!";
            throw new IllegalArgumentException($i$a$-require-EcoMenuBuilder$addComponent$62.toString());
        }
        int maxRows = 1 + this.rows - row2;
        int maxColumns = 10 - column;
        component.init(maxRows, maxColumns);
        if (!(column + component.getColumns() - 1 <= this.columns)) {
            boolean $i$a$-require-EcoMenuBuilder$addComponent$72 = false;
            String $i$a$-require-EcoMenuBuilder$addComponent$72 = "Component is too large to be placed here!";
            throw new IllegalArgumentException($i$a$-require-EcoMenuBuilder$addComponent$72.toString());
        }
        if (!(row2 + component.getRows() - 1 <= this.rows)) {
            boolean bl = false;
            String string = "Component is too large to be placed here!";
            throw new IllegalArgumentException(string.toString());
        }
        GUIPosition guiPosition = new GUIPosition(row2, column);
        List list = this.components.computeIfAbsent(layer, arg_0 -> EcoMenuBuilder.addComponent$lambda$4(addComponent.5.INSTANCE, arg_0)).computeIfAbsent(guiPosition, arg_0 -> EcoMenuBuilder.addComponent$lambda$5(addComponent.6.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(list, "computeIfAbsent(...)");
        ((Collection)list).add(component);
        return this;
    }

    @Override
    @NotNull
    public MenuBuilder modfiy(@NotNull Consumer<MenuBuilder> modifier) {
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        modifier.accept(this);
        return this;
    }

    @Override
    @NotNull
    public MenuBuilder onClose(@NotNull CloseHandler action) {
        Intrinsics.checkNotNullParameter(action, "action");
        ((Collection)this.onClose).add(action);
        return this;
    }

    @Override
    @NotNull
    public MenuBuilder onOpen(@NotNull OpenHandler action) {
        Intrinsics.checkNotNullParameter(action, "action");
        ((Collection)this.onOpen).add(action);
        return this;
    }

    @Override
    @NotNull
    public MenuBuilder onRender(@NotNull BiConsumer<Player, Menu> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        ((Collection)this.onRender).add(new Function2<Player, Menu, Unit>(action){
            final /* synthetic */ BiConsumer<Player, Menu> $action;
            {
                this.$action = $action;
                super(2);
            }

            public final void invoke(@NotNull Player a, @NotNull Menu b) {
                Intrinsics.checkNotNullParameter(a, "a");
                Intrinsics.checkNotNullParameter(b, "b");
                this.$action.accept(a, b);
            }
        });
        return this;
    }

    @Override
    @NotNull
    public MenuBuilder onEvent(@NotNull MenuEventHandler<?> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        ((Collection)this.menuEventHandlers).add(action);
        return this;
    }

    @Override
    @NotNull
    public MenuBuilder onBuild(@NotNull Consumer<Menu> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        ((Collection)this.onBuild).add(new Function1<Menu, Unit>(action){
            final /* synthetic */ Consumer<Menu> $action;
            {
                this.$action = $action;
                super(1);
            }

            public final void invoke(@NotNull Menu it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$action.accept(it);
            }
        });
        return this;
    }

    @Override
    @NotNull
    public MenuBuilder allowChangingHeldItem() {
        this.allowsChangingHeldItem = true;
        return this;
    }

    @Override
    @NotNull
    public Menu build() {
        LayeredComponents layeredComponents = new LayeredComponents();
        block0: for (MenuLayer layer : MenuLayer.values()) {
            int row2 = 1;
            int n = this.rows;
            if (row2 > n) continue;
            while (true) {
                int n2;
                int column;
                if ((column = 1) <= (n2 = this.columns)) {
                    while (true) {
                        Map map2 = this.components.computeIfAbsent(layer, arg_0 -> EcoMenuBuilder.build$lambda$6(build.1.INSTANCE, arg_0));
                        Intrinsics.checkNotNullExpressionValue(map2, "computeIfAbsent(...)");
                        for (Map.Entry entry : map2.entrySet()) {
                            GUIPosition anchor = (GUIPosition)entry.getKey();
                            List availableComponents = (List)entry.getValue();
                            for (GUIComponent component : availableComponents) {
                                int rowOffset = 1 + row2 - anchor.getRow();
                                int columnOffset = 1 + column - anchor.getColumn();
                                if (rowOffset <= 0 || columnOffset <= 0 || rowOffset > component.getRows() || columnOffset > component.getColumns()) continue;
                                GUIPosition point = new GUIPosition(row2, column);
                                layeredComponents.addOffsetComponent(layer, point, new OffsetComponent(component, rowOffset, columnOffset));
                            }
                        }
                        if (column == n2) break;
                        ++column;
                    }
                }
                if (row2 == n) continue block0;
                ++row2;
            }
        }
        EcoMenu menu = new EcoMenu(this.rows, this.columns, layeredComponents, this.title, this.onClose, this.onRender, this.onOpen, this.menuEventHandlers, this.allowsChangingHeldItem);
        Iterable $this$forEach$iv = this.onBuild;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke(menu);
        }
        return menu;
    }

    private static final Map addComponent$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final List addComponent$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final Map build$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Map)$tmp0.invoke(p0);
    }
}

