/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.gui.menu;

import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.menu.MenuLayer;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.internal.gui.menu.EcoMenuKt;
import com.willfp.eco.internal.gui.menu.GUIPosition;
import com.willfp.eco.internal.gui.menu.OffsetComponent;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017R,\u0010\u0003\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/willfp/eco/internal/gui/menu/LayeredComponents;", "", "()V", "layers", "", "Lcom/willfp/eco/core/gui/menu/MenuLayer;", "", "Lcom/willfp/eco/internal/gui/menu/GUIPosition;", "", "Lcom/willfp/eco/internal/gui/menu/OffsetComponent;", "addOffsetComponent", "", "layer", "position", "component", "getSlotAt", "Lcom/willfp/eco/core/gui/slot/Slot;", "row", "", "column", "player", "Lorg/bukkit/entity/Player;", "menu", "Lcom/willfp/eco/core/gui/menu/Menu;", "core-backend"})
public final class LayeredComponents {
    @NotNull
    private final Map<MenuLayer, Map<GUIPosition, List<OffsetComponent>>> layers = new LinkedHashMap();

    @NotNull
    public final Slot getSlotAt(int row2, int column, @Nullable Player player, @NotNull Menu menu) {
        Intrinsics.checkNotNullParameter(menu, "menu");
        GUIPosition guiPosition = new GUIPosition(row2, column);
        List<MenuLayer> list = ArraysKt.reversed(MenuLayer.values());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            List<OffsetComponent> components;
            Map<GUIPosition, List<OffsetComponent>> componentsAtPoints;
            MenuLayer layer = list.get(i);
            if (this.layers.get((Object)layer) == null || componentsAtPoints.get(guiPosition) == null) continue;
            for (OffsetComponent component : components) {
                Slot found = player != null ? component.getComponent().getSlotAt(component.getRowOffset(), component.getColumnOffset(), player, menu) : component.getComponent().getSlotAt(component.getRowOffset(), component.getColumnOffset());
                if (found == null) continue;
                return found;
            }
        }
        return EcoMenuKt.getEmptyFillerSlot();
    }

    public final void addOffsetComponent(@NotNull MenuLayer layer, @NotNull GUIPosition position, @NotNull OffsetComponent component) {
        Map inLayer;
        List list;
        Intrinsics.checkNotNullParameter((Object)layer, "layer");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(component, "component");
        Map map2 = this.layers.get((Object)layer);
        if (map2 == null || (map2 = MapsKt.toMutableMap(map2)) == null) {
            map2 = new LinkedHashMap();
        }
        if ((list = (List)(inLayer = map2).get(position)) == null || (list = CollectionsKt.toMutableList(list)) == null) {
            list = new ArrayList();
        }
        List atPosition = list;
        atPosition.add(component);
        inLayer.put(position, atPosition);
        this.layers.put(layer, inLayer);
    }
}

