/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.gui.menu;

import com.willfp.eco.core.gui.menu.events.CaptiveItemChangeEvent;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.items.ItemsExtensions;
import com.willfp.eco.core.recipe.parts.EmptyTestableItem;
import com.willfp.eco.internal.gui.menu.EcoMenu;
import com.willfp.eco.internal.gui.menu.GUIPosition;
import com.willfp.eco.internal.gui.menu.MenuHandler;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.MenuUtils;
import com.willfp.eco.util.MenuUtilsExtensions;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/willfp/eco/internal/gui/menu/RenderedInventory;", "", "menu", "Lcom/willfp/eco/internal/gui/menu/EcoMenu;", "inventory", "Lorg/bukkit/inventory/Inventory;", "player", "Lorg/bukkit/entity/Player;", "(Lcom/willfp/eco/internal/gui/menu/EcoMenu;Lorg/bukkit/inventory/Inventory;Lorg/bukkit/entity/Player;)V", "captiveItems", "", "Lcom/willfp/eco/internal/gui/menu/GUIPosition;", "Lorg/bukkit/inventory/ItemStack;", "getCaptiveItems", "()Ljava/util/Map;", "getInventory", "()Lorg/bukkit/inventory/Inventory;", "getMenu", "()Lcom/willfp/eco/internal/gui/menu/EcoMenu;", "getPlayer", "()Lorg/bukkit/entity/Player;", "state", "", "getState", "render", "", "renderDefaultCaptiveItems", "core-backend"})
public final class RenderedInventory {
    @NotNull
    private final EcoMenu menu;
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final Player player;
    @NotNull
    private final Map<GUIPosition, ItemStack> captiveItems;
    @NotNull
    private final Map<String, Object> state;

    public RenderedInventory(@NotNull EcoMenu menu, @NotNull Inventory inventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(menu, "menu");
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        Intrinsics.checkNotNullParameter(player, "player");
        this.menu = menu;
        this.inventory = inventory;
        this.player = player;
        this.captiveItems = new LinkedHashMap();
        this.state = new LinkedHashMap();
    }

    @NotNull
    public final EcoMenu getMenu() {
        return this.menu;
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final Map<GUIPosition, ItemStack> getCaptiveItems() {
        return this.captiveItems;
    }

    @NotNull
    public final Map<String, Object> getState() {
        return this.state;
    }

    public final void render() {
        int n;
        int row2;
        ItemStack renderedItem;
        Slot slot;
        int bukkit;
        if (!Intrinsics.areEqual(this.menu, MenuUtilsExtensions.getOpenMenu(this.player))) {
            MenuHandler.INSTANCE.unregisterInventory(this.inventory);
            return;
        }
        Map newCaptive = new LinkedHashMap();
        int row3 = 1;
        int n2 = this.menu.getRows();
        if (row3 <= n2) {
            while (true) {
                int n3;
                int column;
                if ((column = 1) <= (n3 = this.menu.getColumns())) {
                    while (true) {
                        GUIPosition position = new GUIPosition(row3, column);
                        bukkit = MenuUtils.rowColumnToSlot(row3, column, this.menu.getColumns());
                        slot = this.menu.getSlot(row3, column, this.player);
                        Intrinsics.checkNotNullExpressionValue(slot.getItemStack(this.player), "getItemStack(...)");
                        if (slot.isCaptive(this.player, this.menu)) {
                            if (this.inventory.getItem(bukkit) != null) {
                                ItemStack actualItem;
                                if (slot.isCaptiveFromEmpty()) {
                                    if (!ItemsExtensions.isEcoEmpty(actualItem)) {
                                        newCaptive.put(position, actualItem);
                                    }
                                } else if (!Intrinsics.areEqual(actualItem, renderedItem) && !new EmptyTestableItem().matches(actualItem)) {
                                    newCaptive.put(position, actualItem);
                                }
                            }
                        } else {
                            this.inventory.setItem(bukkit, renderedItem);
                        }
                        if (column == n3) break;
                        ++column;
                    }
                }
                if (row3 == n2) break;
                ++row3;
            }
        }
        Map<GUIPosition, ItemStack> previousCaptive = MapsKt.toMap(this.captiveItems);
        this.captiveItems.clear();
        this.captiveItems.putAll(newCaptive);
        for (GUIPosition position : CollectionsKt.union((Iterable)previousCaptive.keySet(), newCaptive.keySet())) {
            if (Intrinsics.areEqual(previousCaptive.get(position), newCaptive.get(position))) continue;
            this.menu.callEvent(this.player, new CaptiveItemChangeEvent(position.getRow(), position.getColumn(), previousCaptive.get(position), (ItemStack)newCaptive.get(position)));
        }
        this.menu.runOnRender(this.player);
        if (!Intrinsics.areEqual(this.captiveItems, previousCaptive) && (row2 = 1) <= (n = this.menu.getRows())) {
            while (true) {
                int n4;
                int column;
                if ((column = 1) <= (n4 = this.menu.getColumns())) {
                    while (true) {
                        bukkit = MenuUtils.rowColumnToSlot(row2, column, this.menu.getColumns());
                        slot = this.menu.getSlot(row2, column, this.player);
                        Intrinsics.checkNotNullExpressionValue(slot.getItemStack(this.player), "getItemStack(...)");
                        if (!slot.isCaptive(this.player, this.menu)) {
                            this.inventory.setItem(bukkit, renderedItem);
                        }
                        if (column == n4) break;
                        ++column;
                    }
                }
                if (row2 == n) break;
                ++row2;
            }
        }
    }

    public final void renderDefaultCaptiveItems() {
        this.menu.runOnRender(this.player);
        int row2 = 1;
        int n = this.menu.getRows();
        if (row2 <= n) {
            while (true) {
                int n2;
                int column;
                if ((column = 1) <= (n2 = this.menu.getColumns())) {
                    while (true) {
                        int bukkit = MenuUtils.rowColumnToSlot(row2, column, this.menu.getColumns());
                        Slot slot = this.menu.getSlot(row2, column, this.player);
                        if (slot.isCaptive(this.player, this.menu)) {
                            this.inventory.setItem(bukkit, slot.getItemStack(this.player));
                        }
                        if (column == n2) break;
                        ++column;
                    }
                }
                if (row2 == n) break;
                ++row2;
            }
        }
    }
}

