/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.items;

import com.willfp.eco.core.items.args.LookupArgParser;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.StringUtils;
import java.util.Locale;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/willfp/eco/internal/items/ArgParserName;", "Lcom/willfp/eco/core/items/args/LookupArgParser;", "()V", "parseArguments", "Ljava/util/function/Predicate;", "Lorg/bukkit/inventory/ItemStack;", "args", "", "", "meta", "Lorg/bukkit/inventory/meta/ItemMeta;", "([Ljava/lang/String;Lorg/bukkit/inventory/meta/ItemMeta;)Ljava/util/function/Predicate;", "serializeBack", "core-backend"})
public final class ArgParserName
implements LookupArgParser {
    @NotNull
    public static final ArgParserName INSTANCE = new ArgParserName();

    private ArgParserName() {
    }

    @Override
    @Nullable
    public Predicate<ItemStack> parseArguments(@NotNull String[] args2, @NotNull ItemMeta meta) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(meta, "meta");
        String name = null;
        for (String arg : args2) {
            String string = arg.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            if (!StringsKt.startsWith$default(string, "name:", false, 2, null)) continue;
            Intrinsics.checkNotNullExpressionValue(arg.substring(5, arg.length()), "substring(...)");
        }
        if (name == null) {
            return null;
        }
        String string = StringUtils.format(name);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        String formatted = string;
        meta.setDisplayName(formatted);
        return arg_0 -> ArgParserName.parseArguments$lambda$0(formatted, arg_0);
    }

    @Override
    @Nullable
    public String serializeBack(@NotNull ItemMeta meta) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        if (!meta.hasDisplayName()) {
            return null;
        }
        return "name:\"" + meta.getDisplayName() + "\"";
    }

    private static final boolean parseArguments$lambda$0(String $formatted, ItemStack it) {
        Intrinsics.checkNotNullParameter($formatted, "$formatted");
        Intrinsics.checkNotNullParameter(it, "it");
        ItemMeta itemMeta = it.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        ItemMeta testMeta = itemMeta;
        return Intrinsics.areEqual(testMeta.getDisplayName(), $formatted);
    }
}

