/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.particle;

import com.willfp.eco.core.particle.ParticleFactory;
import com.willfp.eco.core.particle.SpawnableParticle;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/willfp/eco/internal/particle/ParticleFactoryRGB;", "Lcom/willfp/eco/core/particle/ParticleFactory;", "()V", "create", "Lcom/willfp/eco/core/particle/SpawnableParticle;", "key", "", "getNames", "", "SpawnableParticleRGB", "core-backend"})
public final class ParticleFactoryRGB
implements ParticleFactory {
    @NotNull
    public static final ParticleFactoryRGB INSTANCE = new ParticleFactoryRGB();

    private ParticleFactoryRGB() {
    }

    @Override
    @NotNull
    public List<String> getNames() {
        String[] stringArray = new String[]{"color", "rgb", "hex"};
        return CollectionsKt.listOf(stringArray);
    }

    @Override
    @Nullable
    public SpawnableParticle create(@NotNull String key) {
        Color color;
        Intrinsics.checkNotNullParameter(key, "key");
        Integer n = StringsKt.toIntOrNull(key, 16);
        if (n == null) {
            return null;
        }
        int hex = n;
        try {
            color = Color.fromRGB((int)hex);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Color color2 = color;
        Intrinsics.checkNotNull(color2);
        Color color3 = color2;
        return new SpawnableParticleRGB(new Particle.DustOptions(color3, 1.0f));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/internal/particle/ParticleFactoryRGB$SpawnableParticleRGB;", "Lcom/willfp/eco/core/particle/SpawnableParticle;", "options", "Lorg/bukkit/Particle$DustOptions;", "(Lorg/bukkit/Particle$DustOptions;)V", "spawn", "", "location", "Lorg/bukkit/Location;", "amount", "", "core-backend"})
    private static final class SpawnableParticleRGB
    implements SpawnableParticle {
        @NotNull
        private final Particle.DustOptions options;

        public SpawnableParticleRGB(@NotNull Particle.DustOptions options2) {
            Intrinsics.checkNotNullParameter(options2, "options");
            this.options = options2;
        }

        @Override
        public void spawn(@NotNull Location location, int amount) {
            Intrinsics.checkNotNullParameter(location, "location");
            World world = location.getWorld();
            if (world == null) {
                return;
            }
            World world2 = world;
            world2.spawnParticle(Particle.REDSTONE, location, amount, 0.0, 0.0, 0.0, 0.0, (Object)this.options);
        }
    }
}

