/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.PluginLike;
import com.willfp.eco.core.PluginProps;
import com.willfp.eco.core.command.CommandBase;
import com.willfp.eco.core.command.PluginCommandBase;
import com.willfp.eco.core.config.ConfigType;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.data.ExtendedPersistentDataContainer;
import com.willfp.eco.core.data.PlayerProfile;
import com.willfp.eco.core.data.ServerProfile;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.entities.ai.EntityController;
import com.willfp.eco.core.fast.FastItemStack;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.menu.MenuType;
import com.willfp.eco.core.gui.slot.functional.SlotProvider;
import com.willfp.eco.core.items.CustomItem;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.core.packet.Packet;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.core.proxy.ProxyFactory;
import com.willfp.eco.internal.EcoPropsParser;
import com.willfp.eco.internal.command.EcoPluginCommand;
import com.willfp.eco.internal.command.EcoSubcommand;
import com.willfp.eco.internal.config.ConfigUtilsKt;
import com.willfp.eco.internal.config.EcoConfig;
import com.willfp.eco.internal.config.EcoConfigSection;
import com.willfp.eco.internal.config.EcoLoadableConfig;
import com.willfp.eco.internal.config.EcoUpdatableConfig;
import com.willfp.eco.internal.config.handler.ReflectiveConfigHandler;
import com.willfp.eco.internal.config.handler.SimpleConfigHandler;
import com.willfp.eco.internal.drops.EcoDropQueue;
import com.willfp.eco.internal.drops.EcoFastCollatedDropQueue;
import com.willfp.eco.internal.events.EcoEventManager;
import com.willfp.eco.internal.extensions.EcoExtensionLoader;
import com.willfp.eco.internal.factory.EcoMetadataValueFactory;
import com.willfp.eco.internal.factory.EcoNamespacedKeyFactory;
import com.willfp.eco.internal.factory.EcoRunnableFactory;
import com.willfp.eco.internal.fast.FastInternalNamespacedKeyFactory;
import com.willfp.eco.internal.fast.InternalNamespacedKeyFactory;
import com.willfp.eco.internal.fast.SafeInternalNamespacedKeyFactory;
import com.willfp.eco.internal.gui.MergedStateMenu;
import com.willfp.eco.internal.gui.menu.EcoMenu;
import com.willfp.eco.internal.gui.menu.EcoMenuBuilder;
import com.willfp.eco.internal.gui.menu.RenderedInventory;
import com.willfp.eco.internal.gui.menu.RenderedInventoryKt;
import com.willfp.eco.internal.gui.slot.EcoSlotBuilder;
import com.willfp.eco.internal.integrations.PAPIExpansion;
import com.willfp.eco.internal.logging.EcoLogger;
import com.willfp.eco.internal.logging.NOOPLogger;
import com.willfp.eco.internal.placeholder.PlaceholderParser;
import com.willfp.eco.internal.proxy.EcoProxyFactory;
import com.willfp.eco.internal.scheduling.EcoScheduler;
import com.willfp.eco.internal.spigot.EcoImplKt;
import com.willfp.eco.internal.spigot.EcoSpigotPlugin;
import com.willfp.eco.internal.spigot.data.DataYml;
import com.willfp.eco.internal.spigot.data.KeyRegistry;
import com.willfp.eco.internal.spigot.data.ProfileHandler;
import com.willfp.eco.internal.spigot.data.storage.HandlerType;
import com.willfp.eco.internal.spigot.integrations.bstats.MetricHandler;
import com.willfp.eco.internal.spigot.math.DelegatedExpressionHandler;
import com.willfp.eco.internal.spigot.math.ExpressionHandler;
import com.willfp.eco.internal.spigot.math.ImmediatePlaceholderTranslationExpressionHandler;
import com.willfp.eco.internal.spigot.math.LazyPlaceholderTranslationExpressionHandler;
import com.willfp.eco.internal.spigot.proxy.BukkitCommandsProxy;
import com.willfp.eco.internal.spigot.proxy.CommonsInitializerProxy;
import com.willfp.eco.internal.spigot.proxy.DisplayNameProxy;
import com.willfp.eco.internal.spigot.proxy.DummyEntityFactoryProxy;
import com.willfp.eco.internal.spigot.proxy.EntityControllerFactoryProxy;
import com.willfp.eco.internal.spigot.proxy.ExtendedPersistentDataContainerFactoryProxy;
import com.willfp.eco.internal.spigot.proxy.FastItemStackFactoryProxy;
import com.willfp.eco.internal.spigot.proxy.MiniMessageTranslatorProxy;
import com.willfp.eco.internal.spigot.proxy.PacketHandlerProxy;
import com.willfp.eco.internal.spigot.proxy.SNBTConverterProxy;
import com.willfp.eco.internal.spigot.proxy.SkullProxy;
import com.willfp.eco.internal.spigot.proxy.TPSProxy;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J$\u0010!\u001a\u00020\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020)0(2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J%\u00104\u001a\b\u0012\u0004\u0012\u0002H605\"\b\b\u0000\u00106*\u0002072\u0006\u00108\u001a\u0002H6H\u0016\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J<\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020E2\u0006\u0010F\u001a\u00020$2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030H2\u0006\u0010%\u001a\u00020&2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020L2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020P2\u0006\u0010%\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020S2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020$2\u0006\u0010W\u001a\u00020$H\u0016J\u0010\u0010X\u001a\u00020Y2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010Z\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J0\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010_\u001a\u00020$2\u0006\u0010`\u001a\u00020$2\u0006\u0010a\u001a\u00020JH\u0016J\u0010\u0010b\u001a\u00020c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010d\u001a\u00020e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010f\u001a\u00020g2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020kH\u0016J0\u0010l\u001a\u00020m2\u0006\u0010]\u001a\u00020n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010_\u001a\u00020$2\u0006\u0010`\u001a\u00020$2\u0006\u0010a\u001a\u00020JH\u0016J]\u0010o\u001a\u00020p2\u0006\u0010D\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020E2\u0006\u0010F\u001a\u00020$2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030H2\u0006\u0010q\u001a\u00020J2\u0006\u0010%\u001a\u00020&2\u0006\u0010I\u001a\u00020J2\u0012\u0010r\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0s\"\u00020$H\u0016\u00a2\u0006\u0002\u0010tJ\u001f\u0010u\u001a\u0004\u0018\u00010v2\u0006\u0010w\u001a\u00020$2\u0006\u0010x\u001a\u00020yH\u0016\u00a2\u0006\u0002\u0010zJ\u0010\u0010{\u001a\u00020$2\u0006\u0010|\u001a\u00020$H\u0016J\u0012\u0010}\u001a\u0004\u0018\u00010A2\u0006\u0010~\u001a\u00020$H\u0016J\u000b\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u0001H\u0016J\t\u0010\u0081\u0001\u001a\u00020\u001aH\u0016J\u0010\u0010\u0082\u0001\u001a\t\u0012\u0004\u0012\u00020$0\u0083\u0001H\u0016J\n\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0016J\u0014\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0087\u00012\u0006\u0010.\u001a\u00020/H\u0016J&\u0010\u0088\u0001\u001a\u0004\u0018\u00010$2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0007\u0010\u0089\u0001\u001a\u00020$2\u0006\u0010x\u001a\u00020yH\u0016J\u0013\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u001a2\u0006\u0010_\u001a\u00020$H\u0016J&\u0010\u008b\u0001\u001a\u00030\u008c\u00012\n\u0010\u008d\u0001\u001a\u0005\u0018\u00010\u008c\u00012\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0HH\u0016J\u0015\u0010\u008e\u0001\u001a\u000e\u0012\t\u0012\u0007\u0012\u0002\b\u00030\u0090\u00010\u008f\u0001H\u0016J\n\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0016J\u0015\u0010\u0093\u0001\u001a\u0004\u0018\u00010$2\b\u0010\u0094\u0001\u001a\u00030\u0095\u0001H\u0016J\t\u0010\u0096\u0001\u001a\u00020vH\u0016J\u0014\u0010\u0097\u0001\u001a\u00030\u0098\u00012\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001H\u0016J\t\u0010\u009b\u0001\u001a\u00020\u0016H\u0016J\u0011\u0010\u009c\u0001\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u009d\u0001\u001a\u00020\u00182\u000b\u0010W\u001a\u0007\u0012\u0002\b\u00030\u0090\u0001H\u0016J\u001b\u0010\u009e\u0001\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/2\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u0016J-\u0010\u00a1\u0001\u001a\u00020\u00182\b\u0010\u00a2\u0001\u001a\u00030\u00a3\u00012\u0006\u0010.\u001a\u00020/2\u0007\u0010_\u001a\u00030\u00a4\u00012\u0007\u0010\u00a5\u0001\u001a\u00020JH\u0016J\u001c\u0010\u00a6\u0001\u001a\u00020\u00182\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u00a7\u0001\u001a\u00020$H\u0016J\t\u0010\u00a8\u0001\u001a\u00020\u0018H\u0016J\u0012\u0010\u00a9\u0001\u001a\u00030\u00aa\u00012\u0006\u0010~\u001a\u00020$H\u0016J\u0011\u0010\u00ab\u0001\u001a\u00020$2\u0006\u0010@\u001a\u00020AH\u0016J\u001a\u0010\u00ac\u0001\u001a\u00020$2\u0007\u0010\u00ad\u0001\u001a\u00020$2\u0006\u0010x\u001a\u00020yH\u0016J\u0012\u0010\u00ae\u0001\u001a\u00020\u00182\u0007\u0010\u00af\u0001\u001a\u00020^H\u0016J\u0014\u0010\u00b0\u0001\u001a\u00030\u00b1\u00012\b\u0010\u00b2\u0001\u001a\u00030\u00b3\u0001H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u00b4\u0001"}, d2={"Lcom/willfp/eco/internal/spigot/EcoImpl;", "Lcom/willfp/eco/internal/spigot/EcoSpigotPlugin;", "Lcom/willfp/eco/core/Eco;", "()V", "crunchHandler", "Lcom/willfp/eco/internal/spigot/math/DelegatedExpressionHandler;", "dataYml", "Lcom/willfp/eco/internal/spigot/data/DataYml;", "getDataYml", "()Lcom/willfp/eco/internal/spigot/data/DataYml;", "keyFactory", "Lcom/willfp/eco/internal/fast/InternalNamespacedKeyFactory;", "getKeyFactory$annotations", "placeholderParser", "Lcom/willfp/eco/internal/placeholder/PlaceholderParser;", "profileHandler", "Lcom/willfp/eco/internal/spigot/data/ProfileHandler;", "getProfileHandler", "()Lcom/willfp/eco/internal/spigot/data/ProfileHandler;", "adaptPdc", "Lcom/willfp/eco/core/data/ExtendedPersistentDataContainer;", "container", "Lorg/bukkit/persistence/PersistentDataContainer;", "addNewPlugin", "", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "blendMenuState", "Lcom/willfp/eco/internal/gui/MergedStateMenu;", "base", "Lcom/willfp/eco/core/gui/menu/Menu;", "additional", "clean", "createConfig", "Lcom/willfp/eco/internal/config/EcoConfigSection;", "contents", "", "type", "Lcom/willfp/eco/core/config/ConfigType;", "values", "", "", "createConfigHandler", "Lcom/willfp/eco/internal/config/handler/SimpleConfigHandler;", "createDropQueue", "Lcom/willfp/eco/internal/drops/EcoDropQueue;", "player", "Lorg/bukkit/entity/Player;", "createDummyEntity", "Lorg/bukkit/entity/Entity;", "location", "Lorg/bukkit/Location;", "createEntityController", "Lcom/willfp/eco/core/entities/ai/EntityController;", "T", "Lorg/bukkit/entity/Mob;", "mob", "(Lorg/bukkit/entity/Mob;)Lcom/willfp/eco/core/entities/ai/EntityController;", "createEventManager", "Lcom/willfp/eco/internal/events/EcoEventManager;", "createExtensionLoader", "Lcom/willfp/eco/internal/extensions/EcoExtensionLoader;", "createFastItemStack", "Lcom/willfp/eco/core/fast/FastItemStack;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "createLoadableConfig", "Lcom/willfp/eco/internal/config/EcoLoadableConfig;", "configName", "Lcom/willfp/eco/core/PluginLike;", "subDirectoryPath", "source", "Ljava/lang/Class;", "requiresChangesToSave", "", "createLogger", "Lcom/willfp/eco/internal/logging/EcoLogger;", "createMenuBuilder", "Lcom/willfp/eco/internal/gui/menu/EcoMenuBuilder;", "rows", "", "Lcom/willfp/eco/core/gui/menu/MenuType;", "createMetadataValueFactory", "Lcom/willfp/eco/internal/factory/EcoMetadataValueFactory;", "createNamespacedKey", "Lorg/bukkit/NamespacedKey;", "namespace", "key", "createNamespacedKeyFactory", "Lcom/willfp/eco/internal/factory/EcoNamespacedKeyFactory;", "createPAPIIntegration", "createPluginCommand", "Lcom/willfp/eco/internal/command/EcoPluginCommand;", "parentDelegate", "Lcom/willfp/eco/core/command/PluginCommandBase;", "name", "permission", "playersOnly", "createProxyFactory", "Lcom/willfp/eco/internal/proxy/EcoProxyFactory;", "createRunnableFactory", "Lcom/willfp/eco/internal/factory/EcoRunnableFactory;", "createScheduler", "Lcom/willfp/eco/internal/scheduling/EcoScheduler;", "createSlotBuilder", "Lcom/willfp/eco/internal/gui/slot/EcoSlotBuilder;", "provider", "Lcom/willfp/eco/core/gui/slot/functional/SlotProvider;", "createSubcommand", "Lcom/willfp/eco/internal/command/EcoSubcommand;", "Lcom/willfp/eco/core/command/CommandBase;", "createUpdatableConfig", "Lcom/willfp/eco/internal/config/EcoUpdatableConfig;", "removeUnused", "updateBlacklist", "", "(Ljava/lang/String;Lcom/willfp/eco/core/PluginLike;Ljava/lang/String;Ljava/lang/Class;ZLcom/willfp/eco/core/config/ConfigType;Z[Ljava/lang/String;)Lcom/willfp/eco/internal/config/EcoUpdatableConfig;", "evaluate", "", "expression", "context", "Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;", "(Ljava/lang/String;Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;)Ljava/lang/Double;", "formatMiniMessage", "message", "fromSNBT", "snbt", "getAdventure", "Lnet/kyori/adventure/platform/bukkit/BukkitAudiences;", "getEcoPlugin", "getLoadedPlugins", "", "getNOOPLogger", "Lcom/willfp/eco/internal/logging/NOOPLogger;", "getOpenMenu", "Lcom/willfp/eco/internal/gui/menu/EcoMenu;", "getPlaceholderValue", "args", "getPluginByName", "getProps", "Lcom/willfp/eco/core/PluginProps;", "existing", "getRegisteredPersistentDataKeys", "", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "getServerProfile", "Lcom/willfp/eco/core/data/ServerProfile;", "getSkullTexture", "meta", "Lorg/bukkit/inventory/meta/SkullMeta;", "getTPS", "loadPlayerProfile", "Lcom/willfp/eco/core/data/PlayerProfile;", "uuid", "Ljava/util/UUID;", "newPdc", "registerBStats", "registerPersistentKey", "sendPacket", "packet", "Lcom/willfp/eco/core/packet/Packet;", "setClientsideDisplayName", "entity", "Lorg/bukkit/entity/LivingEntity;", "Lnet/kyori/adventure/text/Component;", "visible", "setSkullTexture", "base64", "syncCommands", "testableItemFromSNBT", "Lcom/willfp/eco/core/items/TestableItem;", "toSNBT", "translatePlaceholders", "text", "unregisterCommand", "command", "wrapConfigurationSection", "Lcom/willfp/eco/core/config/interfaces/Config;", "bukkit", "Lorg/bukkit/configuration/ConfigurationSection;", "core-plugin"})
public final class EcoImpl
extends EcoSpigotPlugin
implements Eco {
    @NotNull
    private final DataYml dataYml = new DataYml(this);
    @NotNull
    private final ProfileHandler profileHandler;
    @Nullable
    private final InternalNamespacedKeyFactory keyFactory;
    @NotNull
    private final PlaceholderParser placeholderParser;
    @NotNull
    private final DelegatedExpressionHandler crunchHandler;

    public EcoImpl() {
        String string = this.getConfigYml().getString("data-handler");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        this.profileHandler = new ProfileHandler(HandlerType.valueOf(string2), this);
        this.getProxy(CommonsInitializerProxy.class).init(this);
        this.keyFactory = this.getConfigYml().getBool("use-safer-namespacedkey-creation") ? (InternalNamespacedKeyFactory)new SafeInternalNamespacedKeyFactory() : (InternalNamespacedKeyFactory)new FastInternalNamespacedKeyFactory();
        this.placeholderParser = new PlaceholderParser();
        this.crunchHandler = new DelegatedExpressionHandler(this, this.getConfigYml().getBool("use-immediate-placeholder-translation-for-math") ? (ExpressionHandler)new ImmediatePlaceholderTranslationExpressionHandler(this.placeholderParser) : (ExpressionHandler)new LazyPlaceholderTranslationExpressionHandler(this.placeholderParser));
    }

    @Override
    @NotNull
    public DataYml getDataYml() {
        return this.dataYml;
    }

    @Override
    @NotNull
    protected ProfileHandler getProfileHandler() {
        return this.profileHandler;
    }

    private static /* synthetic */ void getKeyFactory$annotations() {
    }

    @Override
    @NotNull
    public EcoScheduler createScheduler(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return new EcoScheduler(plugin);
    }

    @Override
    @NotNull
    public EcoEventManager createEventManager(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return new EcoEventManager(plugin);
    }

    @Override
    @NotNull
    public EcoNamespacedKeyFactory createNamespacedKeyFactory(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return new EcoNamespacedKeyFactory(plugin);
    }

    @Override
    @NotNull
    public EcoMetadataValueFactory createMetadataValueFactory(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return new EcoMetadataValueFactory(plugin);
    }

    @Override
    @NotNull
    public EcoRunnableFactory createRunnableFactory(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return new EcoRunnableFactory(plugin);
    }

    @Override
    @NotNull
    public EcoExtensionLoader createExtensionLoader(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return new EcoExtensionLoader(plugin);
    }

    @Override
    @NotNull
    public SimpleConfigHandler createConfigHandler(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return plugin.getProps().isUsingReflectiveReload() ? (SimpleConfigHandler)new ReflectiveConfigHandler(plugin) : new SimpleConfigHandler();
    }

    @Override
    @NotNull
    public EcoLogger createLogger(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return new EcoLogger(plugin);
    }

    @Override
    @NotNull
    public NOOPLogger getNOOPLogger() {
        return NOOPLogger.INSTANCE;
    }

    @Override
    public void createPAPIIntegration(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        new PAPIExpansion(plugin);
    }

    @Override
    @NotNull
    public EcoPlugin getEcoPlugin() {
        return this;
    }

    @Override
    @NotNull
    public EcoConfigSection createConfig(@NotNull String contents, @NotNull ConfigType type2) {
        Intrinsics.checkNotNullParameter(contents, "contents");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        return new EcoConfigSection(type2, ConfigUtilsKt.toMap(type2, contents), null, 4, null);
    }

    @NotNull
    public EcoConfigSection createConfig(@NotNull Map<String, ? extends Object> values2, @NotNull ConfigType type2) {
        Intrinsics.checkNotNullParameter(values2, "values");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        return new EcoConfigSection(type2, values2, null, 4, null);
    }

    @Override
    @NotNull
    public EcoLoadableConfig createLoadableConfig(@NotNull String configName, @NotNull PluginLike plugin, @NotNull String subDirectoryPath, @NotNull Class<?> source, @NotNull ConfigType type2, boolean requiresChangesToSave) {
        Intrinsics.checkNotNullParameter(configName, "configName");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(subDirectoryPath, "subDirectoryPath");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        return new EcoLoadableConfig(type2, configName, plugin, subDirectoryPath, source, requiresChangesToSave);
    }

    @Override
    @NotNull
    public EcoUpdatableConfig createUpdatableConfig(@NotNull String configName, @NotNull PluginLike plugin, @NotNull String subDirectoryPath, @NotNull Class<?> source, boolean removeUnused, @NotNull ConfigType type2, boolean requiresChangesToSave, String ... updateBlacklist) {
        Intrinsics.checkNotNullParameter(configName, "configName");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(subDirectoryPath, "subDirectoryPath");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(updateBlacklist, "updateBlacklist");
        return new EcoUpdatableConfig(type2, configName, plugin, subDirectoryPath, source, removeUnused, requiresChangesToSave, Arrays.copyOf(updateBlacklist, updateBlacklist.length));
    }

    @Override
    @NotNull
    public Config wrapConfigurationSection(@NotNull ConfigurationSection bukkit) {
        Intrinsics.checkNotNullParameter(bukkit, "bukkit");
        Config config = this.createConfig(MapsKt.emptyMap(), ConfigType.YAML);
        for (String key : bukkit.getKeys(true)) {
            Intrinsics.checkNotNull(key);
            ((EcoConfig)config).set(key, bukkit.get(key));
        }
        return config;
    }

    @Override
    @NotNull
    public EcoPluginCommand createPluginCommand(@NotNull PluginCommandBase parentDelegate, @NotNull EcoPlugin plugin, @NotNull String name, @NotNull String permission, boolean playersOnly) {
        Intrinsics.checkNotNullParameter(parentDelegate, "parentDelegate");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(permission, "permission");
        return new EcoPluginCommand(parentDelegate, plugin, name, permission, playersOnly);
    }

    @Override
    @NotNull
    public EcoSubcommand createSubcommand(@NotNull CommandBase parentDelegate, @NotNull EcoPlugin plugin, @NotNull String name, @NotNull String permission, boolean playersOnly) {
        Intrinsics.checkNotNullParameter(parentDelegate, "parentDelegate");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(permission, "permission");
        return new EcoSubcommand(parentDelegate, plugin, name, permission, playersOnly);
    }

    @Override
    @NotNull
    public EcoDropQueue createDropQueue(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.getConfigYml().getBool("use-fast-collated-drops") ? (EcoDropQueue)new EcoFastCollatedDropQueue(player) : new EcoDropQueue(player);
    }

    @Override
    @NotNull
    public Set<PersistentDataKey<?>> getRegisteredPersistentDataKeys() {
        return KeyRegistry.INSTANCE.getRegisteredKeys();
    }

    @Override
    public void registerPersistentKey(@NotNull PersistentDataKey<?> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        KeyRegistry.INSTANCE.registerKey(key);
    }

    @Override
    @NotNull
    public EcoMenuBuilder createMenuBuilder(int rows, @NotNull MenuType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        return new EcoMenuBuilder(rows, type2.getColumns());
    }

    @Override
    @NotNull
    public EcoSlotBuilder createSlotBuilder(@NotNull SlotProvider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        return new EcoSlotBuilder(provider);
    }

    @Override
    @NotNull
    public MergedStateMenu blendMenuState(@NotNull Menu base, @NotNull Menu additional) {
        Intrinsics.checkNotNullParameter(base, "base");
        Intrinsics.checkNotNullParameter(additional, "additional");
        return new MergedStateMenu(base, additional);
    }

    @Override
    public void clean(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        String string = plugin.getProxyPackage();
        Intrinsics.checkNotNullExpressionValue(string, "getProxyPackage(...)");
        if (((CharSequence)string).length() > 0) {
            ProxyFactory proxyFactory = plugin.getProxyFactory();
            Intrinsics.checkNotNull(proxyFactory, "null cannot be cast to non-null type com.willfp.eco.internal.proxy.EcoProxyFactory");
            EcoProxyFactory factory = (EcoProxyFactory)proxyFactory;
            factory.clean();
        }
        Map map2 = EcoImplKt.access$getLoadedEcoPlugins$p();
        String string2 = plugin.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        map2.remove(string3);
        for (CustomItem customItem : Items.getCustomItems()) {
            String string4 = customItem.getKey().getNamespace();
            String string5 = plugin.getName();
            Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
            String string6 = string5.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string6, "toLowerCase(...)");
            if (!StringsKt.equals(string4, string6, true)) continue;
            Items.removeCustomItem(customItem.getKey());
        }
        ClassLoader classLoader = plugin.getClass().getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            ((URLClassLoader)classLoader).close();
        }
        System.gc();
    }

    @Override
    @NotNull
    public EcoProxyFactory createProxyFactory(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return new EcoProxyFactory(plugin);
    }

    @Override
    public void addNewPlugin(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Map map2 = EcoImplKt.access$getLoadedEcoPlugins$p();
        String string = plugin.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String string3 = string2;
        map2.put(string3, plugin);
        map2 = EcoImplKt.access$getLoadedEcoPlugins$p();
        String string4 = plugin.getID();
        Intrinsics.checkNotNullExpressionValue(string4, "getID(...)");
        map2.put(string4, plugin);
    }

    @Override
    @NotNull
    public List<String> getLoadedPlugins() {
        return CollectionsKt.toList(EcoImplKt.access$getLoadedEcoPlugins$p().keySet());
    }

    @Override
    @Nullable
    public EcoPlugin getPluginByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Map map2 = EcoImplKt.access$getLoadedEcoPlugins$p();
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return (EcoPlugin)map2.get(string);
    }

    @Override
    @NotNull
    public FastItemStack createFastItemStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        return this.getProxy(FastItemStackFactoryProxy.class).create(itemStack);
    }

    @Override
    public void registerBStats(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        MetricHandler.INSTANCE.createMetrics(plugin);
    }

    @Override
    @Nullable
    public BukkitAudiences getAdventure() {
        return this.getBukkitAudiences();
    }

    @Override
    @NotNull
    public ServerProfile getServerProfile() {
        return this.getProfileHandler().loadServerProfile();
    }

    @Override
    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return this.getProfileHandler().load(uuid);
    }

    @Override
    @NotNull
    public Entity createDummyEntity(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.getProxy(DummyEntityFactoryProxy.class).createDummyEntity(location);
    }

    @Override
    @NotNull
    public NamespacedKey createNamespacedKey(@NotNull String namespace, @NotNull String key) {
        Intrinsics.checkNotNullParameter(namespace, "namespace");
        Intrinsics.checkNotNullParameter(key, "key");
        InternalNamespacedKeyFactory internalNamespacedKeyFactory = this.keyFactory;
        if (internalNamespacedKeyFactory == null || (internalNamespacedKeyFactory = internalNamespacedKeyFactory.create(namespace, key)) == null) {
            internalNamespacedKeyFactory = new NamespacedKey(namespace, key);
        }
        return internalNamespacedKeyFactory;
    }

    @Override
    @NotNull
    public PluginProps getProps(@Nullable PluginProps existing, @NotNull Class<? extends EcoPlugin> plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        PluginProps pluginProps = existing;
        if (pluginProps == null) {
            pluginProps = EcoPropsParser.INSTANCE.parseForPlugin(plugin);
        }
        return pluginProps;
    }

    @Override
    @NotNull
    public <T extends Mob> EntityController<T> createEntityController(@NotNull T mob) {
        Intrinsics.checkNotNullParameter(mob, "mob");
        return this.getProxy(EntityControllerFactoryProxy.class).createEntityController(mob);
    }

    @Override
    @NotNull
    public String formatMiniMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return this.getProxy(MiniMessageTranslatorProxy.class).format(message);
    }

    @Override
    @NotNull
    public ExtendedPersistentDataContainer adaptPdc(@NotNull PersistentDataContainer container) {
        Intrinsics.checkNotNullParameter(container, "container");
        return this.getProxy(ExtendedPersistentDataContainerFactoryProxy.class).adapt(container);
    }

    @Override
    @NotNull
    public PersistentDataContainer newPdc() {
        return this.getProxy(ExtendedPersistentDataContainerFactoryProxy.class).newPdc();
    }

    @Override
    @NotNull
    public String toSNBT(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        return this.getProxy(SNBTConverterProxy.class).toSNBT(itemStack);
    }

    @Override
    @Nullable
    public ItemStack fromSNBT(@NotNull String snbt) {
        Intrinsics.checkNotNullParameter(snbt, "snbt");
        return this.getProxy(SNBTConverterProxy.class).fromSNBT(snbt);
    }

    @Override
    @NotNull
    public TestableItem testableItemFromSNBT(@NotNull String snbt) {
        Intrinsics.checkNotNullParameter(snbt, "snbt");
        return this.getProxy(SNBTConverterProxy.class).makeSNBTTestable(snbt);
    }

    @Override
    @Nullable
    public String getSkullTexture(@NotNull SkullMeta meta) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        return this.getProxy(SkullProxy.class).getSkullTexture(meta);
    }

    @Override
    public void setSkullTexture(@NotNull SkullMeta meta, @NotNull String base64) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        Intrinsics.checkNotNullParameter(base64, "base64");
        this.getProxy(SkullProxy.class).setSkullTexture(meta, base64);
    }

    @Override
    public double getTPS() {
        return this.getProxy(TPSProxy.class).getTPS();
    }

    @Override
    @Nullable
    public Double evaluate(@NotNull String expression, @NotNull PlaceholderContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        return this.crunchHandler.evaluate(expression, context);
    }

    @Override
    @Nullable
    public EcoMenu getOpenMenu(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
        return renderedInventory != null ? renderedInventory.getMenu() : null;
    }

    @Override
    public void syncCommands() {
        this.getProxy(BukkitCommandsProxy.class).syncCommands();
    }

    @Override
    public void unregisterCommand(@NotNull PluginCommandBase command2) {
        Intrinsics.checkNotNullParameter(command2, "command");
        this.getProxy(BukkitCommandsProxy.class).unregisterCommand(command2);
    }

    @Override
    public void sendPacket(@NotNull Player player, @NotNull Packet packet) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.getProxy(PacketHandlerProxy.class).sendPacket(player, packet);
    }

    @Override
    @NotNull
    public String translatePlaceholders(@NotNull String text, @NotNull PlaceholderContext context) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(context, "context");
        return this.placeholderParser.translatePlacholders(text, context);
    }

    @Override
    @Nullable
    public String getPlaceholderValue(@Nullable EcoPlugin plugin, @NotNull String args2, @NotNull PlaceholderContext context) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(context, "context");
        return this.placeholderParser.getPlaceholderResult(plugin, args2, context);
    }

    @Override
    public void setClientsideDisplayName(@NotNull LivingEntity entity, @NotNull Player player, @NotNull Component name, boolean visible) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(name, "name");
        this.getProxy(DisplayNameProxy.class).setClientsideDisplayName(entity, player, name, visible);
    }
}

