/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.arrows;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.items.ItemsExtensions;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.projectiles.ProjectileSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/internal/spigot/arrows/ArrowDataListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "onLaunch", "", "event", "Lorg/bukkit/event/entity/ProjectileLaunchEvent;", "core-plugin"})
public final class ArrowDataListener
implements Listener {
    @NotNull
    private final EcoPlugin plugin;

    public ArrowDataListener(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onLaunch(@NotNull ProjectileLaunchEvent event) {
        ItemStack item;
        Intrinsics.checkNotNullParameter(event, "event");
        Projectile projectile = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(projectile, "getEntity(...)");
        Projectile arrow = projectile;
        if (!(arrow instanceof Arrow)) {
            return;
        }
        if (!(((Arrow)arrow).getShooter() instanceof LivingEntity)) {
            return;
        }
        ProjectileSource projectileSource = ((Arrow)arrow).getShooter();
        Intrinsics.checkNotNull(projectileSource, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntity entity = (LivingEntity)projectileSource;
        EntityEquipment entityEquipment = entity.getEquipment();
        Object object = item = entityEquipment != null ? entityEquipment.getItemInMainHand() : null;
        if (ItemsExtensions.isEcoEmpty(item) || item == null) {
            return;
        }
        arrow.setMetadata("shot-from", (MetadataValue)this.plugin.createMetadataValue(item));
    }
}

