/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.data;

import com.willfp.eco.core.data.Profile;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.internal.spigot.data.EcoProfileKt;
import com.willfp.eco.internal.spigot.data.storage.DataHandler;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB5\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J%\u0010\u0015\u001a\u0002H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0004H\u0016\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u00020\u001a\"\b\b\u0000\u0010\u0016*\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00042\u0006\u0010\u001b\u001a\u0002H\u0016H\u0016\u00a2\u0006\u0002\u0010\u001cR!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/willfp/eco/internal/spigot/data/EcoProfile;", "Lcom/willfp/eco/core/data/Profile;", "data", "", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "", "uuid", "Ljava/util/UUID;", "handler", "Lcom/willfp/eco/internal/spigot/data/storage/DataHandler;", "localHandler", "(Ljava/util/Map;Ljava/util/UUID;Lcom/willfp/eco/internal/spigot/data/storage/DataHandler;Lcom/willfp/eco/internal/spigot/data/storage/DataHandler;)V", "getData", "()Ljava/util/Map;", "getUuid", "()Ljava/util/UUID;", "equals", "", "other", "hashCode", "", "read", "T", "key", "(Lcom/willfp/eco/core/data/keys/PersistentDataKey;)Ljava/lang/Object;", "write", "", "value", "(Lcom/willfp/eco/core/data/keys/PersistentDataKey;Ljava/lang/Object;)V", "Companion", "core-plugin"})
public abstract class EcoProfile
implements Profile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<PersistentDataKey<?>, Object> data;
    @NotNull
    private final UUID uuid;
    @NotNull
    private final DataHandler handler;
    @NotNull
    private final DataHandler localHandler;
    @NotNull
    private static final Set<UUID> CHANGE_MAP;

    public EcoProfile(@NotNull Map<PersistentDataKey<?>, Object> data2, @NotNull UUID uuid, @NotNull DataHandler handler, @NotNull DataHandler localHandler) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(handler, "handler");
        Intrinsics.checkNotNullParameter(localHandler, "localHandler");
        this.data = data2;
        this.uuid = uuid;
        this.handler = handler;
        this.localHandler = localHandler;
    }

    @NotNull
    public final Map<PersistentDataKey<?>, Object> getData() {
        return this.data;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @Override
    public <T> void write(@NotNull PersistentDataKey<T> key, @NotNull T value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        this.data.put(key, value);
        CHANGE_MAP.add(this.uuid);
    }

    @Override
    @NotNull
    public <T> T read(@NotNull PersistentDataKey<T> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (this.data.containsKey(key)) {
            Object object = this.data.get(key);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of com.willfp.eco.internal.spigot.data.EcoProfile.read");
            return (T)object;
        }
        Map<PersistentDataKey<?>, Object> map2 = this.data;
        T t2 = EcoProfileKt.access$isSavedLocally(key) ? this.localHandler.read(this.uuid, key) : this.handler.read(this.uuid, key);
        if (t2 == null) {
            t2 = key.getDefaultValue();
        }
        T t3 = t2;
        Intrinsics.checkNotNull(t3);
        map2.put(key, t3);
        return this.read(key);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof EcoProfile)) {
            return false;
        }
        return Intrinsics.areEqual(this.uuid, ((EcoProfile)other).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    static {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, "newKeySet(...)");
        CHANGE_MAP = keySetView;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/willfp/eco/internal/spigot/data/EcoProfile$Companion;", "", "()V", "CHANGE_MAP", "", "Ljava/util/UUID;", "getCHANGE_MAP", "()Ljava/util/Set;", "core-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<UUID> getCHANGE_MAP() {
            return CHANGE_MAP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

