/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.data;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.NamespacedKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\bJ\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0006J\u001c\u0010\f\u001a\u00020\n\"\u0004\b\u0000\u0010\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\u0006H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/willfp/eco/internal/spigot/data/KeyRegistry;", "", "()V", "registry", "", "Lorg/bukkit/NamespacedKey;", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "getRegisteredKeys", "", "registerKey", "", "key", "validateKey", "T", "core-plugin"})
public final class KeyRegistry {
    @NotNull
    public static final KeyRegistry INSTANCE = new KeyRegistry();
    @NotNull
    private static final Map<NamespacedKey, PersistentDataKey<?>> registry = new LinkedHashMap();

    private KeyRegistry() {
    }

    public final void registerKey(@NotNull PersistentDataKey<?> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (registry.containsKey(key.getKey())) {
            registry.remove(key.getKey());
        }
        this.validateKey(key);
        Map<NamespacedKey, PersistentDataKey<?>> map2 = registry;
        NamespacedKey namespacedKey = key.getKey();
        Intrinsics.checkNotNullExpressionValue(namespacedKey, "getKey(...)");
        map2.put(namespacedKey, key);
    }

    @NotNull
    public final Set<PersistentDataKey<?>> getRegisteredKeys() {
        return CollectionsKt.toMutableSet((Iterable)registry.values());
    }

    private final <T> void validateKey(PersistentDataKey<T> key) {
        block14: {
            PersistentDataKeyType<T> persistentDataKeyType;
            T t2;
            block18: {
                block19: {
                    block17: {
                        block16: {
                            block15: {
                                block13: {
                                    t2 = key.getDefaultValue();
                                    persistentDataKeyType = key.getType();
                                    if (!Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.INT)) break block13;
                                    if (!(t2 instanceof Integer)) {
                                        throw new IllegalArgumentException("Invalid Data Type! Should be Int");
                                    }
                                    break block14;
                                }
                                if (!Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.DOUBLE)) break block15;
                                if (!(t2 instanceof Double)) {
                                    throw new IllegalArgumentException("Invalid Data Type! Should be Double");
                                }
                                break block14;
                            }
                            if (!Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.BOOLEAN)) break block16;
                            if (!(t2 instanceof Boolean)) {
                                throw new IllegalArgumentException("Invalid Data Type! Should be Boolean");
                            }
                            break block14;
                        }
                        if (!Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.STRING)) break block17;
                        if (!(t2 instanceof String)) {
                            throw new IllegalArgumentException("Invalid Data Type! Should be String");
                        }
                        break block14;
                    }
                    if (!Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.STRING_LIST)) break block18;
                    if (!(t2 instanceof List)) break block19;
                    Object t3 = CollectionsKt.firstOrNull((List)t2);
                    if (t3 == null ? true : t3 instanceof String) break block14;
                }
                throw new IllegalArgumentException("Invalid Data Type! Should be String List");
            }
            if (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.CONFIG)) {
                if (!(t2 instanceof Config)) {
                    throw new IllegalArgumentException("Invalid Data Type! Should be Config");
                }
            } else if (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.BIG_DECIMAL)) {
                if (!(t2 instanceof BigDecimal)) {
                    throw new IllegalArgumentException("Invalid Data Type! Should be BigDecimal");
                }
            } else {
                throw new NullPointerException("Null value found!");
            }
        }
    }
}

