/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.data;

import com.willfp.eco.core.data.PlayerProfile;
import com.willfp.eco.core.data.Profile;
import com.willfp.eco.core.data.ProfileExtensions;
import com.willfp.eco.core.data.ServerProfile;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.internal.spigot.EcoSpigotPlugin;
import com.willfp.eco.internal.spigot.ServerLocking;
import com.willfp.eco.internal.spigot.data.EcoPlayerProfile;
import com.willfp.eco.internal.spigot.data.EcoProfile;
import com.willfp.eco.internal.spigot.data.EcoServerProfile;
import com.willfp.eco.internal.spigot.data.ProfileHandlerKt;
import com.willfp.eco.internal.spigot.data.storage.DataHandler;
import com.willfp.eco.internal.spigot.data.storage.HandlerType;
import com.willfp.eco.internal.spigot.data.storage.MongoDataHandler;
import com.willfp.eco.internal.spigot.data.storage.MySQLDataHandler;
import com.willfp.eco.internal.spigot.data.storage.YamlDataHandler;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\rJ\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0014J\u0006\u0010\u001c\u001a\u00020\u0014J \u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\r2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fJ\u0006\u0010!\u001a\u00020\u0014J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/willfp/eco/internal/spigot/data/ProfileHandler;", "", "type", "Lcom/willfp/eco/internal/spigot/data/storage/HandlerType;", "plugin", "Lcom/willfp/eco/internal/spigot/EcoSpigotPlugin;", "(Lcom/willfp/eco/internal/spigot/data/storage/HandlerType;Lcom/willfp/eco/internal/spigot/EcoSpigotPlugin;)V", "handler", "Lcom/willfp/eco/internal/spigot/data/storage/DataHandler;", "getHandler", "()Lcom/willfp/eco/internal/spigot/data/storage/DataHandler;", "loaded", "", "Ljava/util/UUID;", "Lcom/willfp/eco/internal/spigot/data/EcoProfile;", "localHandler", "Lcom/willfp/eco/internal/spigot/data/storage/YamlDataHandler;", "accessLoadedProfile", "uuid", "initialize", "", "load", "Lcom/willfp/eco/core/data/PlayerProfile;", "loadGenericProfile", "Lcom/willfp/eco/core/data/Profile;", "loadServerProfile", "Lcom/willfp/eco/core/data/ServerProfile;", "migrateIfNeeded", "save", "saveKeysFor", "keys", "", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "startAutosaving", "unloadPlayer", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nProfileHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileHandler.kt\ncom/willfp/eco/internal/spigot/data/ProfileHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,186:1\n11065#2:187\n11400#2,3:188\n*S KotlinDebug\n*F\n+ 1 ProfileHandler.kt\ncom/willfp/eco/internal/spigot/data/ProfileHandler\n*L\n120#1:187\n120#1:188,3\n*E\n"})
public final class ProfileHandler {
    @NotNull
    private final HandlerType type;
    @NotNull
    private final EcoSpigotPlugin plugin;
    @NotNull
    private final Map<UUID, EcoProfile> loaded;
    @NotNull
    private final YamlDataHandler localHandler;
    @NotNull
    private final DataHandler handler;

    public ProfileHandler(@NotNull HandlerType type2, @NotNull EcoSpigotPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.type = type2;
        this.plugin = plugin;
        this.loaded = new LinkedHashMap();
        this.localHandler = new YamlDataHandler(this.plugin, this);
        this.handler = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> this.localHandler;
            case 2 -> new MySQLDataHandler(this.plugin, this);
            case 3 -> new MongoDataHandler(this.plugin, this);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final DataHandler getHandler() {
        return this.handler;
    }

    @Nullable
    public final EcoProfile accessLoadedProfile(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return this.loaded.get(uuid);
    }

    @NotNull
    public final Profile loadGenericProfile(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        EcoProfile found = this.loaded.get(uuid);
        if (found != null) {
            return found;
        }
        Map data2 = new LinkedHashMap();
        EcoProfile profile2 = Intrinsics.areEqual(uuid, ProfileHandlerKt.getServerProfileUUID()) ? (EcoProfile)new EcoServerProfile(data2, this.handler, this.localHandler) : (EcoProfile)new EcoPlayerProfile(data2, uuid, this.handler, this.localHandler);
        this.loaded.put(uuid, profile2);
        return profile2;
    }

    @NotNull
    public final PlayerProfile load(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Profile profile2 = this.loadGenericProfile(uuid);
        Intrinsics.checkNotNull(profile2, "null cannot be cast to non-null type com.willfp.eco.core.data.PlayerProfile");
        return (PlayerProfile)profile2;
    }

    @NotNull
    public final ServerProfile loadServerProfile() {
        Profile profile2 = this.loadGenericProfile(ProfileHandlerKt.getServerProfileUUID());
        Intrinsics.checkNotNull(profile2, "null cannot be cast to non-null type com.willfp.eco.core.data.ServerProfile");
        return (ServerProfile)profile2;
    }

    public final void saveKeysFor(@NotNull UUID uuid, @NotNull Set<? extends PersistentDataKey<?>> keys2) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(keys2, "keys");
        EcoProfile ecoProfile = this.accessLoadedProfile(uuid);
        if (ecoProfile == null) {
            return;
        }
        EcoProfile profile2 = ecoProfile;
        Map map2 = new LinkedHashMap();
        for (PersistentDataKey<?> key : keys2) {
            Object object;
            Map map3 = map2;
            if (profile2.getData().get(key) == null) continue;
            map3.put(key, object);
        }
        this.handler.saveKeysFor(uuid, map2);
        if (!Intrinsics.areEqual(this.localHandler, this.handler)) {
            this.localHandler.saveKeysFor(uuid, map2);
        }
    }

    public final void unloadPlayer(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        this.loaded.remove(uuid);
    }

    public final void save() {
        this.handler.save();
        if (!Intrinsics.areEqual(this.localHandler, this.handler)) {
            this.localHandler.save();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void migrateIfNeeded() {
        void $this$mapTo$iv$iv;
        if (!this.plugin.getConfigYml().getBool("perform-data-migration")) {
            return;
        }
        if (!this.plugin.getDataYml().has("previous-handler")) {
            this.plugin.getDataYml().set("previous-handler", this.type.name());
            this.plugin.getDataYml().save();
        }
        String string = this.plugin.getDataYml().getString("previous-handler");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        HandlerType previousHandlerType = HandlerType.valueOf(string);
        if (previousHandlerType == this.type) {
            return;
        }
        DataHandler previousHandler = switch (WhenMappings.$EnumSwitchMapping$0[previousHandlerType.ordinal()]) {
            case 1 -> new YamlDataHandler(this.plugin, this);
            case 2 -> new MySQLDataHandler(this.plugin, this);
            case 3 -> new MongoDataHandler(this.plugin, this);
            default -> throw new NoWhenBranchMatchedException();
        };
        ServerLocking.INSTANCE.lock("Migrating player data! Check console for more information.");
        this.plugin.getLogger().info("eco has detected a change in data handler!");
        this.plugin.getLogger().info("Migrating server data from " + previousHandlerType.name() + " to " + this.type.name());
        this.plugin.getLogger().info("This will take a while!");
        this.plugin.getLogger().info("Initializing previous handler...");
        previousHandler.initialize();
        OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
        Intrinsics.checkNotNullExpressionValue(offlinePlayerArray, "getOfflinePlayers(...)");
        Object[] $this$map$iv = offlinePlayerArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OfflinePlayer offlinePlayer = (OfflinePlayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUniqueId());
        }
        List players = (List)destination$iv$iv;
        this.plugin.getLogger().info("Found data for " + players.size() + " players!");
        int i = 1;
        for (UUID uuid : players) {
            this.plugin.getLogger().info("Migrating data for " + uuid + "... (" + i + " / " + players.size() + ")");
            for (PersistentDataKey<?> key : PersistentDataKey.values()) {
                if (Intrinsics.areEqual(key.getKey().getKey(), "known_points")) continue;
                try {
                    Intrinsics.checkNotNull(uuid);
                    Intrinsics.checkNotNull(key);
                    ProfileHandler.migrateIfNeeded$migrateKey(uuid, key, previousHandler, this.handler);
                }
                catch (Exception e) {
                    this.plugin.getLogger().info("Could not migrate " + key.getKey() + " for " + uuid + "! This is probably because they do not have any data.");
                }
            }
            ++i;
        }
        this.plugin.getLogger().info("Saving new data...");
        this.handler.save();
        this.plugin.getLogger().info("Updating previous handler...");
        this.plugin.getDataYml().set("previous-handler", this.type.name());
        this.plugin.getDataYml().save();
        this.plugin.getLogger().info("The server will now automatically be restarted...");
        ServerLocking.INSTANCE.unlock();
        Bukkit.getServer().shutdown();
    }

    public final void initialize() {
        this.handler.initialize();
        if (!Intrinsics.areEqual(this.localHandler, this.handler)) {
            this.localHandler.initialize();
        }
    }

    public final void startAutosaving() {
        if (!this.plugin.getConfigYml().getBool("yaml.autosave")) {
            return;
        }
        long interval = (long)this.plugin.getConfigYml().getInt("yaml.autosave-interval") * 20L;
        this.plugin.getScheduler().runTimer(20L, interval, () -> ProfileHandler.startAutosaving$lambda$1(this));
    }

    private static final <T> void migrateIfNeeded$migrateKey(UUID uuid, PersistentDataKey<T> key, DataHandler from, DataHandler to) {
        T previous = from.read(uuid, key);
        if (previous != null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
            ProfileExtensions.getProfile(offlinePlayer).write(key, previous);
            to.write(uuid, key, previous);
        }
    }

    private static final void startAutosaving$lambda$1(ProfileHandler this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.handler.saveAsync();
        this$0.localHandler.saveAsync();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HandlerType.values().length];
            try {
                nArray[HandlerType.YAML.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HandlerType.MYSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HandlerType.MONGO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

