/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.data.storage;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.willfp.eco.core.config.ConfigExtensions;
import com.willfp.eco.core.config.ConfigType;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.eco.internal.spigot.EcoSpigotPlugin;
import com.willfp.eco.internal.spigot.data.ProfileHandler;
import com.willfp.eco.internal.spigot.data.storage.DataHandler;
import com.willfp.eco.internal.spigot.data.storage.HandlerType;
import com.willfp.eco.internal.spigot.data.storage.MySQLDataHandler;
import com.willfp.eco.libs.hikari.HikariConfig;
import com.willfp.eco.libs.hikari.HikariDataSource;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.exposed.dao.id.UUIDTable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.statements.UpdateStatement;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001aH\u0016J/\u0010&\u001a\u0004\u0018\u0001H'\"\b\b\u0000\u0010'*\u00020!2\u0006\u0010\u001b\u001a\u00020\u00132\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0016\u00a2\u0006\u0002\u0010*J(\u0010+\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0016\u0010,\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\u0004\u0012\u00020!0-H\u0016J\u0018\u0010.\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J5\u0010/\u001a\u00020\u001a\"\b\b\u0000\u0010'*\u00020!2\u0006\u0010\u001b\u001a\u00020\u00132\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)2\u0006\u00100\u001a\u0002H'H\u0016\u00a2\u0006\u0002\u00101R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0011\u001aB\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00140\u0014 \u0010* \u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0010*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/willfp/eco/internal/spigot/data/storage/MySQLDataHandler;", "Lcom/willfp/eco/internal/spigot/data/storage/DataHandler;", "plugin", "Lcom/willfp/eco/internal/spigot/EcoSpigotPlugin;", "handler", "Lcom/willfp/eco/internal/spigot/data/ProfileHandler;", "(Lcom/willfp/eco/internal/spigot/EcoSpigotPlugin;Lcom/willfp/eco/internal/spigot/data/ProfileHandler;)V", "dataColumn", "Lorg/jetbrains/exposed/sql/Column;", "", "getDataColumn", "()Lorg/jetbrains/exposed/sql/Column;", "database", "Lorg/jetbrains/exposed/sql/Database;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "rows", "Lcom/github/benmanes/caffeine/cache/Cache;", "Ljava/util/UUID;", "Lorg/jetbrains/exposed/sql/ResultRow;", "table", "Lorg/jetbrains/exposed/dao/id/UUIDTable;", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "doSetData", "", "uuid", "config", "Lcom/willfp/eco/core/config/interfaces/Config;", "equals", "", "other", "", "getData", "hashCode", "", "initialize", "read", "T", "key", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "(Ljava/util/UUID;Lcom/willfp/eco/core/data/keys/PersistentDataKey;)Ljava/lang/Object;", "saveKeysFor", "keys", "", "setData", "write", "value", "(Ljava/util/UUID;Lcom/willfp/eco/core/data/keys/PersistentDataKey;Ljava/lang/Object;)V", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nMySQLDataHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MySQLDataHandler.kt\ncom/willfp/eco/internal/spigot/data/storage/MySQLDataHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n223#2,2:171\n*S KotlinDebug\n*F\n+ 1 MySQLDataHandler.kt\ncom/willfp/eco/internal/spigot/data/storage/MySQLDataHandler\n*L\n51#1:171,2\n*E\n"})
public final class MySQLDataHandler
extends DataHandler {
    @NotNull
    private final ProfileHandler handler;
    @NotNull
    private final Database database;
    @NotNull
    private final UUIDTable table;
    private final Cache<UUID, ResultRow> rows;
    private final ThreadFactory threadFactory;
    private final ExecutorService executor;

    public MySQLDataHandler(@NotNull EcoSpigotPlugin plugin, @NotNull ProfileHandler handler) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(handler, "handler");
        super(HandlerType.MYSQL);
        this.handler = handler;
        this.table = new UUIDTable("eco_data", null, 2, null);
        this.rows = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.SECONDS).build();
        this.threadFactory = new ThreadFactoryBuilder().setNameFormat("eco-mysql-thread-%d").build();
        this.executor = Executors.newFixedThreadPool(plugin.getConfigYml().getInt("mysql.threads"), this.threadFactory);
        HikariConfig config = new HikariConfig();
        config.setDriverClassName("com.mysql.cj.jdbc.Driver");
        config.setUsername(plugin.getConfigYml().getString("mysql.user"));
        config.setPassword(plugin.getConfigYml().getString("mysql.password"));
        config.setJdbcUrl("jdbc:mysql://" + plugin.getConfigYml().getString("mysql.host") + ":" + plugin.getConfigYml().getString("mysql.port") + "/" + plugin.getConfigYml().getString("mysql.database"));
        config.setMaximumPoolSize(plugin.getConfigYml().getInt("mysql.connections"));
        this.database = Database.Companion.connect$default(Database.Companion, new HikariDataSource(config), null, null, null, 14, null);
        ThreadLocalTransactionManagerKt.transaction(this.database, (Function1)new Function1<Transaction, Unit>(){

            @Override
            public final void invoke(@NotNull Transaction $this$transaction) {
                Intrinsics.checkNotNullParameter($this$transaction, "$this$transaction");
                Object object = new UUIDTable[]{table};
                SchemaUtils.create$default(SchemaUtils.INSTANCE, (Table[])object, false, 2, null);
                Object $this$invoke_u24lambda_u240 = object = table;
                boolean bl = false;
                ((Table)$this$invoke_u24lambda_u240).registerColumn("json_data", new TextColumnType(null, false, 3, null));
                object = new Table[]{table};
                SchemaUtils.createMissingTablesAndColumns$default(SchemaUtils.INSTANCE, (Table[])object, false, false, 2, null);
            }
        });
    }

    private final Column<String> getDataColumn() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.table.getColumns();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Column it = (Column)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), "json_data")) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t2 = element$iv2;
        Intrinsics.checkNotNull(t2, "null cannot be cast to non-null type org.jetbrains.exposed.sql.Column<kotlin.String>");
        return (Column)t2;
    }

    @Override
    @Nullable
    public <T> T read(@NotNull UUID uuid, @NotNull PersistentDataKey<T> key) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(key, "key");
        Config data2 = this.getData(uuid);
        PersistentDataKeyType<T> persistentDataKeyType = key.getType();
        Object value = Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.INT) ? data2.getIntOrNull(key.getKey().toString()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.DOUBLE) ? data2.getDoubleOrNull(key.getKey().toString()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.STRING) ? data2.getStringOrNull(key.getKey().toString()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.BOOLEAN) ? data2.getBoolOrNull(key.getKey().toString()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.STRING_LIST) ? data2.getStringsOrNull(key.getKey().toString()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.CONFIG) ? data2.getSubsectionOrNull(key.getKey().toString()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.BIG_DECIMAL) ? data2.getBigDecimalOrNull(key.getKey().toString()) : null))))));
        Integer n = value;
        if (n == null) {
            n = null;
        }
        return (T)n;
    }

    @Override
    public <T> void write(@NotNull UUID uuid, @NotNull PersistentDataKey<T> key, @NotNull T value) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        Config data2 = this.getData(uuid);
        data2.set(key.getKey().toString(), value);
        this.setData(uuid, data2);
    }

    @Override
    public void saveKeysFor(@NotNull UUID uuid, @NotNull Map<PersistentDataKey<?>, ? extends Object> keys2) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(keys2, "keys");
        this.executor.submit(() -> MySQLDataHandler.saveKeysFor$lambda$1(this, uuid, keys2));
    }

    private final Config getData(UUID uuid) {
        String plaintext2 = (String)ThreadLocalTransactionManagerKt.transaction(this.database, (Function1)new Function1<Transaction, String>(this, uuid){
            final /* synthetic */ MySQLDataHandler this$0;
            final /* synthetic */ UUID $uuid;
            {
                this.this$0 = $receiver;
                this.$uuid = $uuid;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Transaction $this$transaction) {
                Intrinsics.checkNotNullParameter($this$transaction, "$this$transaction");
                ResultRow row2 = MySQLDataHandler.access$getRows$p(this.this$0).get(this.$uuid, arg_0 -> getData.plaintext.1.invoke$lambda$0(new Function1<UUID, ResultRow>(this.this$0, this.$uuid){
                    final /* synthetic */ MySQLDataHandler this$0;
                    final /* synthetic */ UUID $uuid;
                    {
                        this.this$0 = $receiver;
                        this.$uuid = $uuid;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final ResultRow invoke(UUID it) {
                        ResultRow resultRow;
                        SqlExpressionBuilder $this$invoke_u24lambda_u240;
                        FieldSet $this$select$iv;
                        FieldSet fieldSet = MySQLDataHandler.access$getTable$p(this.this$0);
                        MySQLDataHandler mySQLDataHandler = this.this$0;
                        UUID uUID = this.$uuid;
                        boolean $i$f$select = false;
                        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
                        FieldSet fieldSet2 = $this$select$iv;
                        boolean bl = false;
                        ResultRow row2 = (ResultRow)CollectionsKt.singleOrNull(SizedIterable.DefaultImpls.limit$default(QueriesKt.select(fieldSet2, $this$invoke_u24lambda_u240.eq((ExpressionWithColumnType)MySQLDataHandler.access$getTable$p(mySQLDataHandler).getId(), (Comparable)uUID)), 1, 0L, 2, null));
                        if (row2 != null) {
                            resultRow = row2;
                        } else {
                            void $this$invoke_u24lambda_u241;
                            ThreadLocalTransactionManagerKt.transaction(MySQLDataHandler.access$getDatabase$p(this.this$0), (Function1)new Function1<Transaction, InsertStatement<Number>>(this.this$0, this.$uuid){
                                final /* synthetic */ MySQLDataHandler this$0;
                                final /* synthetic */ UUID $uuid;
                                {
                                    this.this$0 = $receiver;
                                    this.$uuid = $uuid;
                                    super(1);
                                }

                                @NotNull
                                public final InsertStatement<Number> invoke(@NotNull Transaction $this$transaction) {
                                    Intrinsics.checkNotNullParameter($this$transaction, "$this$transaction");
                                    return QueriesKt.insert((Table)MySQLDataHandler.access$getTable$p(this.this$0), (Function2)new Function2<UUIDTable, InsertStatement<Number>, Unit>(this.$uuid, this.this$0){
                                        final /* synthetic */ UUID $uuid;
                                        final /* synthetic */ MySQLDataHandler this$0;
                                        {
                                            this.$uuid = $uuid;
                                            this.this$0 = $receiver;
                                            super(2);
                                        }

                                        public final void invoke(@NotNull UUIDTable $this$insert, @NotNull InsertStatement<Number> it) {
                                            Intrinsics.checkNotNullParameter($this$insert, "$this$insert");
                                            Intrinsics.checkNotNullParameter(it, "it");
                                            it.setWithEntityIdValue($this$insert.getId(), (Comparable)this.$uuid);
                                            it.set(MySQLDataHandler.access$getDataColumn(this.this$0), "{}");
                                        }
                                    });
                                }
                            });
                            $this$select$iv = MySQLDataHandler.access$getTable$p(this.this$0);
                            mySQLDataHandler = this.this$0;
                            uUID = this.$uuid;
                            $i$f$select = false;
                            $this$invoke_u24lambda_u240 = SqlExpressionBuilder.INSTANCE;
                            fieldSet2 = $this$select$iv;
                            boolean bl2 = false;
                            resultRow = (ResultRow)CollectionsKt.singleOrNull(SizedIterable.DefaultImpls.limit$default(QueriesKt.select(fieldSet2, $this$invoke_u24lambda_u241.eq((ExpressionWithColumnType)MySQLDataHandler.access$getTable$p(mySQLDataHandler).getId(), (Comparable)uUID)), 1, 0L, 2, null));
                        }
                        return resultRow;
                    }
                }, arg_0));
                String string = (String)row2.getOrNull(MySQLDataHandler.access$getDataColumn(this.this$0));
                if (string == null) {
                    string = "{}";
                }
                return string;
            }

            private static final ResultRow invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (ResultRow)$tmp0.invoke(p0);
            }
        });
        return ConfigExtensions.readConfig(plaintext2, ConfigType.JSON);
    }

    private final void setData(UUID uuid, Config config) {
        this.executor.submit(() -> MySQLDataHandler.setData$lambda$2(this, uuid, config));
    }

    private final void doSetData(UUID uuid, Config config) {
        ThreadLocalTransactionManagerKt.transaction(this.database, (Function1)new Function1<Transaction, Integer>(this, uuid, config){
            final /* synthetic */ MySQLDataHandler this$0;
            final /* synthetic */ UUID $uuid;
            final /* synthetic */ Config $config;
            {
                this.this$0 = $receiver;
                this.$uuid = $uuid;
                this.$config = $config;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull Transaction $this$transaction) {
                Intrinsics.checkNotNullParameter($this$transaction, "$this$transaction");
                return QueriesKt.update$default(MySQLDataHandler.access$getTable$p(this.this$0), (Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(this.this$0, this.$uuid){
                    final /* synthetic */ MySQLDataHandler this$0;
                    final /* synthetic */ UUID $uuid;
                    {
                        this.this$0 = $receiver;
                        this.$uuid = $uuid;
                        super(1);
                    }

                    @NotNull
                    public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$update) {
                        Intrinsics.checkNotNullParameter($this$update, "$this$update");
                        return $this$update.eq((ExpressionWithColumnType)MySQLDataHandler.access$getTable$p(this.this$0).getId(), (Comparable)this.$uuid);
                    }
                }, null, new Function2<UUIDTable, UpdateStatement, Unit>(this.this$0, this.$config){
                    final /* synthetic */ MySQLDataHandler this$0;
                    final /* synthetic */ Config $config;
                    {
                        this.this$0 = $receiver;
                        this.$config = $config;
                        super(2);
                    }

                    public final void invoke(@NotNull UUIDTable $this$update, @NotNull UpdateStatement it) {
                        Intrinsics.checkNotNullParameter($this$update, "$this$update");
                        Intrinsics.checkNotNullParameter(it, "it");
                        Column column = MySQLDataHandler.access$getDataColumn(this.this$0);
                        String string = this.$config.toPlaintext();
                        Intrinsics.checkNotNullExpressionValue(string, "toPlaintext(...)");
                        it.set(column, string);
                    }
                }, 2, null);
            }
        });
    }

    @Override
    public void initialize() {
        ThreadLocalTransactionManagerKt.transaction(this.database, (Function1)new Function1<Transaction, Unit>(this){
            final /* synthetic */ MySQLDataHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Transaction $this$transaction) {
                Intrinsics.checkNotNullParameter($this$transaction, "$this$transaction");
                Table[] tableArray = new Table[]{MySQLDataHandler.access$getTable$p(this.this$0)};
                SchemaUtils.createMissingTablesAndColumns$default(SchemaUtils.INSTANCE, tableArray, false, false, 2, null);
            }
        });
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MySQLDataHandler;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    private static final void saveKeysFor$lambda$1(MySQLDataHandler this$0, UUID $uuid, Map $keys) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($uuid, "$uuid");
        Intrinsics.checkNotNullParameter($keys, "$keys");
        Config data2 = this$0.getData($uuid);
        for (Map.Entry entry : $keys.entrySet()) {
            PersistentDataKey key = (PersistentDataKey)entry.getKey();
            Object value = entry.getValue();
            data2.set(key.getKey().toString(), value);
        }
        this$0.doSetData($uuid, data2);
    }

    private static final void setData$lambda$2(MySQLDataHandler this$0, UUID $uuid, Config $config) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($uuid, "$uuid");
        Intrinsics.checkNotNullParameter($config, "$config");
        this$0.doSetData($uuid, $config);
    }

    public static final /* synthetic */ Cache access$getRows$p(MySQLDataHandler $this) {
        return $this.rows;
    }

    public static final /* synthetic */ Database access$getDatabase$p(MySQLDataHandler $this) {
        return $this.database;
    }

    public static final /* synthetic */ Column access$getDataColumn(MySQLDataHandler $this) {
        return $this.getDataColumn();
    }
}

