/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.eventlisteners;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.internal.spigot.eventlisteners.EntityDeathByEntityBuilder;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/willfp/eco/internal/spigot/eventlisteners/EntityDeathByEntityListeners;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "events", "", "Lcom/willfp/eco/internal/spigot/eventlisteners/EntityDeathByEntityBuilder;", "onEntityDamage", "", "event", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onEntityDeath", "Lorg/bukkit/event/entity/EntityDeathEvent;", "core-plugin"})
public final class EntityDeathByEntityListeners
implements Listener {
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private final Set<EntityDeathByEntityBuilder> events;

    public EntityDeathByEntityListeners(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.events = new LinkedHashSet();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void onEntityDamage(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntity victim = (LivingEntity)entity;
        if (victim.getHealth() > event.getFinalDamage()) {
            return;
        }
        EntityDeathByEntityBuilder builtEvent = new EntityDeathByEntityBuilder();
        builtEvent.setVictim(victim);
        builtEvent.setDamager(event.getDamager());
        ((Collection)this.events).add(builtEvent);
        this.plugin.getScheduler().runLater(5L, () -> EntityDeathByEntityListeners.onEntityDamage$lambda$0(this, builtEvent));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void onEntityDeath(@NotNull EntityDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(livingEntity, "getEntity(...)");
        LivingEntity victim = livingEntity;
        List list = event.getDrops();
        Intrinsics.checkNotNullExpressionValue(list, "getDrops(...)");
        List drops = list;
        int xp = event.getDroppedExp();
        EntityDeathByEntityBuilder builtEvent = null;
        for (EntityDeathByEntityBuilder builder : this.events) {
            if (!Intrinsics.areEqual(builder.getVictim(), victim)) continue;
            builtEvent = builder;
        }
        if (builtEvent == null) {
            return;
        }
        this.events.remove(builtEvent);
        builtEvent.setDrops(drops);
        builtEvent.setXp(xp);
        builtEvent.setDeathEvent(event);
        builtEvent.push();
    }

    private static final void onEntityDamage$lambda$0(EntityDeathByEntityListeners this$0, EntityDeathByEntityBuilder $builtEvent) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($builtEvent, "$builtEvent");
        this$0.events.remove($builtEvent);
    }
}

