/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.eventlisteners;

import com.willfp.eco.core.events.PlayerJumpEvent;
import com.willfp.eco.core.integrations.mcmmo.McmmoManager;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/willfp/eco/internal/spigot/eventlisteners/PlayerJumpListenersSpigot;", "Lorg/bukkit/event/Listener;", "()V", "onJump", "", "event", "Lorg/bukkit/event/player/PlayerMoveEvent;", "Companion", "core-plugin"})
public final class PlayerJumpListenersSpigot
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<UUID> PREVIOUS_PLAYERS_ON_GROUND = new HashSet();
    @NotNull
    private static final DecimalFormat FORMAT = new DecimalFormat("0.00");

    @EventHandler(ignoreCancelled=true)
    public final void onJump(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (McmmoManager.isFake((Event)event)) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (player2.getVelocity().getY() > 0.0) {
            float jumpVelocity = 0.42f;
            if (player2.hasPotionEffect(PotionEffectType.JUMP)) {
                PotionEffect potionEffect = player2.getPotionEffect(PotionEffectType.JUMP);
                Intrinsics.checkNotNull(potionEffect);
                jumpVelocity += ((float)potionEffect.getAmplifier() + 1.0f) * 0.1f;
            }
            String string = FORMAT.format(jumpVelocity);
            Intrinsics.checkNotNullExpressionValue(string, "format(...)");
            jumpVelocity = Float.parseFloat(StringsKt.replace$default(string, ',', '.', false, 4, null));
            if (event.getPlayer().getLocation().getBlock().getType() != Material.LADDER && PREVIOUS_PLAYERS_ON_GROUND.contains(player2.getUniqueId()) && !player2.isOnGround() && Float.compare((float)player2.getVelocity().getY(), jumpVelocity) == 0) {
                Bukkit.getPluginManager().callEvent((Event)new PlayerJumpEvent(event));
            }
        }
        if (player2.isOnGround()) {
            UUID uUID = player2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            PREVIOUS_PLAYERS_ON_GROUND.add(uUID);
        } else {
            PREVIOUS_PLAYERS_ON_GROUND.remove(player2.getUniqueId());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/willfp/eco/internal/spigot/eventlisteners/PlayerJumpListenersSpigot$Companion;", "", "()V", "FORMAT", "Ljava/text/DecimalFormat;", "PREVIOUS_PLAYERS_ON_GROUND", "", "Ljava/util/UUID;", "core-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

