/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.eventlisteners.armor;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.events.ArmorChangeEvent;
import com.willfp.eco.core.events.ArmorEquipEvent;
import com.willfp.eco.internal.spigot.eventlisteners.armor.ArmorType;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.PluginManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/internal/spigot/eventlisteners/armor/ArmorChangeEventListeners;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "dispenseArmorEvent", "", "event", "Lorg/bukkit/event/block/BlockDispenseArmorEvent;", "onArmorChange", "Lcom/willfp/eco/core/events/ArmorEquipEvent;", "core-plugin"})
public final class ArmorChangeEventListeners
implements Listener {
    @NotNull
    private final EcoPlugin plugin;

    public ArmorChangeEventListeners(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler
    public final void onArmorChange(@NotNull ArmorEquipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        ItemStack[] itemStackArray = player2.getInventory().getArmorContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getArmorContents(...)");
        List<Object> before = ArraysKt.toMutableList((Object[])itemStackArray);
        this.plugin.getScheduler().run(() -> ArmorChangeEventListeners.onArmorChange$lambda$0(player2, before));
    }

    @EventHandler
    public final void dispenseArmorEvent(@NotNull BlockDispenseArmorEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ArmorType type2 = ArmorType.Companion.matchType(event.getItem());
        if (type2 != null && event.getTargetEntity() instanceof Player) {
            PluginManager pluginManager = Bukkit.getPluginManager();
            LivingEntity livingEntity = event.getTargetEntity();
            Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
            pluginManager.callEvent((Event)new ArmorEquipEvent((Player)livingEntity));
        }
    }

    private static final void onArmorChange$lambda$0(Player $player, List $before) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($before, "$before");
        ItemStack[] itemStackArray = $player.getInventory().getArmorContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getArmorContents(...)");
        List<Object> after = ArraysKt.toMutableList((Object[])itemStackArray);
        ArmorChangeEvent armorChangeEvent = new ArmorChangeEvent($player, $before, after);
        Bukkit.getPluginManager().callEvent((Event)armorChangeEvent);
    }
}

