/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.eventlisteners.armor;

import com.willfp.eco.core.events.ArmorEquipEvent;
import com.willfp.eco.internal.spigot.eventlisteners.armor.ArmorType;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/willfp/eco/internal/spigot/eventlisteners/armor/ArmorListener;", "Lorg/bukkit/event/Listener;", "()V", "inventoryClick", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "inventoryDrag", "Lorg/bukkit/event/inventory/InventoryDragEvent;", "itemBreakEvent", "Lorg/bukkit/event/player/PlayerItemBreakEvent;", "playerDeathEvent", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "playerInteractEvent", "e", "Lorg/bukkit/event/player/PlayerInteractEvent;", "playerJoinEvent", "Lorg/bukkit/event/player/PlayerJoinEvent;", "playerRespawnEvent", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "Companion", "core-plugin"})
public final class ArmorListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void inventoryClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        boolean shift = false;
        boolean numberkey = false;
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() == InventoryAction.NOTHING) {
            return;
        }
        if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT) {
            shift = true;
        }
        if (event.getClick() == ClickType.NUMBER_KEY) {
            numberkey = true;
        }
        if (event.getSlotType() != InventoryType.SlotType.ARMOR && event.getSlotType() != InventoryType.SlotType.QUICKBAR && event.getSlotType() != InventoryType.SlotType.CONTAINER) {
            return;
        }
        if (event.getClickedInventory() != null) {
            Inventory inventory = event.getClickedInventory();
            Intrinsics.checkNotNull(inventory);
            if (inventory.getType() != InventoryType.PLAYER) {
                return;
            }
        }
        if (event.getInventory().getType() != InventoryType.CRAFTING && event.getInventory().getType() != InventoryType.PLAYER) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ArmorType newArmorType = ArmorType.Companion.matchType(shift ? event.getCurrentItem() : event.getCursor());
        if (!shift && newArmorType != null && event.getRawSlot() != newArmorType.getSlot()) {
            return;
        }
        if (shift) {
            newArmorType = ArmorType.Companion.matchType(event.getCurrentItem());
            if (newArmorType != null) {
                boolean equipping = true;
                if (event.getRawSlot() == newArmorType.getSlot()) {
                    equipping = false;
                }
                if (newArmorType == ArmorType.HELMET && equipping == Companion.isAirOrNull(event.getWhoClicked().getInventory().getHelmet()) || newArmorType == ArmorType.CHESTPLATE && equipping == Companion.isAirOrNull(event.getWhoClicked().getInventory().getChestplate()) || newArmorType == ArmorType.LEGGINGS && equipping == Companion.isAirOrNull(event.getWhoClicked().getInventory().getLeggings()) || newArmorType == ArmorType.BOOTS && equipping == Companion.isAirOrNull(event.getWhoClicked().getInventory().getBoots())) {
                    HumanEntity humanEntity = event.getWhoClicked();
                    Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
                    ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)humanEntity);
                    Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
                }
            }
        } else {
            if (numberkey) {
                Inventory inventory = event.getClickedInventory();
                Intrinsics.checkNotNull(inventory);
                if (inventory.getType() == InventoryType.PLAYER) {
                    Inventory inventory2 = event.getClickedInventory();
                    Intrinsics.checkNotNull(inventory2);
                    ItemStack hotbarItem = inventory2.getItem(event.getHotbarButton());
                    newArmorType = !Companion.isAirOrNull(hotbarItem) ? ArmorType.Companion.matchType(hotbarItem) : ArmorType.Companion.matchType(!Companion.isAirOrNull(event.getCurrentItem()) ? event.getCurrentItem() : event.getCursor());
                }
            } else if (Companion.isAirOrNull(event.getCursor()) && !Companion.isAirOrNull(event.getCurrentItem())) {
                newArmorType = ArmorType.Companion.matchType(event.getCurrentItem());
            }
            if (newArmorType != null && event.getRawSlot() == newArmorType.getSlot()) {
                HumanEntity humanEntity = event.getWhoClicked();
                Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)humanEntity);
                Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void playerInteractEvent(@NotNull PlayerInteractEvent e) {
        ArmorType newArmorType;
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (e.getAction() == Action.PHYSICAL) {
            return;
        }
        if ((e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) && (newArmorType = ArmorType.Companion.matchType(e.getItem())) != null && (newArmorType == ArmorType.HELMET && Companion.isAirOrNull(e.getPlayer().getInventory().getHelmet()) || newArmorType == ArmorType.CHESTPLATE && Companion.isAirOrNull(e.getPlayer().getInventory().getChestplate()) || newArmorType == ArmorType.LEGGINGS && Companion.isAirOrNull(e.getPlayer().getInventory().getLeggings()) || newArmorType == ArmorType.BOOTS && Companion.isAirOrNull(e.getPlayer().getInventory().getBoots()))) {
            ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(e.getPlayer());
            Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void inventoryDrag(@NotNull InventoryDragEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ArmorType type2 = ArmorType.Companion.matchType(event.getOldCursor());
        if (event.getRawSlots().isEmpty()) {
            return;
        }
        if (type2 != null) {
            Integer n = event.getRawSlots().stream().findFirst().orElse(0);
            if (n != null && type2.getSlot() == n.intValue()) {
                HumanEntity humanEntity = event.getWhoClicked();
                Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)humanEntity);
                Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
            }
        }
    }

    @EventHandler
    public final void playerJoinEvent(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(event.getPlayer());
        Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
    }

    @EventHandler
    public final void playerRespawnEvent(@NotNull PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(event.getPlayer());
        Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
    }

    @EventHandler
    public final void itemBreakEvent(@NotNull PlayerItemBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ArmorType type2 = ArmorType.Companion.matchType(event.getBrokenItem());
        if (type2 != null) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            Player p = player;
            ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(p);
            Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
        }
    }

    @EventHandler
    public final void playerDeathEvent(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(player, "getEntity(...)");
        Player p = player;
        if (event.getKeepInventory()) {
            return;
        }
        ItemStack[] itemStackArray = p.getInventory().getArmorContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getArmorContents(...)");
        for (ItemStack i : itemStackArray) {
            if (Companion.isAirOrNull(i)) continue;
            Bukkit.getPluginManager().callEvent((Event)new ArmorEquipEvent(p));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/internal/spigot/eventlisteners/armor/ArmorListener$Companion;", "", "()V", "isAirOrNull", "", "item", "Lorg/bukkit/inventory/ItemStack;", "core-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAirOrNull(@Nullable ItemStack item) {
            return item == null || item.getType() == Material.AIR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

