/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.antigrief;

import com.willfp.eco.core.integrations.antigrief.AntigriefIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/antigrief/AntigriefBentoBox;", "Lcom/willfp/eco/core/integrations/antigrief/AntigriefIntegration;", "()V", "canBreakBlock", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "canCreateExplosion", "location", "Lorg/bukkit/Location;", "canInjure", "victim", "Lorg/bukkit/entity/LivingEntity;", "canPickupItem", "canPlaceBlock", "equals", "other", "", "getPluginName", "", "hashCode", "", "core-plugin"})
public final class AntigriefBentoBox
implements AntigriefIntegration {
    @Override
    public boolean canBreakBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        Island island = BentoBox.getInstance().getIslandsManager().getIslandAt(block.getLocation()).orElse(null);
        if (island == null) {
            return true;
        }
        Island island2 = island;
        return island2.isAllowed(User.getInstance((Player)player), Flags.BREAK_BLOCKS);
    }

    @Override
    public boolean canCreateExplosion(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        Island island = BentoBox.getInstance().getIslandsManager().getIslandAt(location).orElse(null);
        if (island == null) {
            return true;
        }
        Island island2 = island;
        return island2.isAllowed(User.getInstance((Player)player), Flags.TNT_DAMAGE);
    }

    @Override
    public boolean canPlaceBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        Island island = BentoBox.getInstance().getIslandsManager().getIslandAt(block.getLocation()).orElse(null);
        if (island == null) {
            return true;
        }
        Island island2 = island;
        return island2.isAllowed(User.getInstance((Player)player), Flags.PLACE_BLOCKS);
    }

    @Override
    public boolean canInjure(@NotNull Player player, @NotNull LivingEntity victim) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(victim, "victim");
        Island island = BentoBox.getInstance().getIslandsManager().getIslandAt(victim.getLocation()).orElse(null);
        if (island == null) {
            return true;
        }
        Island island2 = island;
        LivingEntity livingEntity = victim;
        if (livingEntity instanceof Player) {
            User user = User.getInstance((Player)player);
            bl = island2.isAllowed(user, switch (WhenMappings.$EnumSwitchMapping$0[((Player)victim).getWorld().getEnvironment().ordinal()]) {
                case 1 -> Flags.PVP_OVERWORLD;
                case 2 -> Flags.PVP_NETHER;
                case 3 -> Flags.PVP_END;
                default -> Flags.PVP_OVERWORLD;
            });
        } else {
            bl = livingEntity instanceof Monster ? island2.isAllowed(User.getInstance((Player)player), Flags.HURT_MONSTERS) : island2.isAllowed(User.getInstance((Player)player), Flags.HURT_ANIMALS);
        }
        return bl;
    }

    @Override
    public boolean canPickupItem(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        Island island = BentoBox.getInstance().getIslandsManager().getIslandAt(location).orElse(null);
        if (island == null) {
            return true;
        }
        Island island2 = island;
        return island2.isAllowed(User.getInstance((Player)player), Flags.ITEM_PICKUP);
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "BentoBox";
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AntigriefIntegration)) {
            return false;
        }
        return Intrinsics.areEqual(((AntigriefIntegration)other).getPluginName(), this.getPluginName());
    }

    public int hashCode() {
        return this.getPluginName().hashCode();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[World.Environment.values().length];
            try {
                nArray[World.Environment.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.NETHER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.THE_END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

