/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.bstats;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.internal.spigot.integrations.bstats.Metrics;
import com.willfp.eco.internal.spigot.integrations.bstats.MetricsKt;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics;", "", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "metricsBase", "Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics$MetricsBase;", "playerAmount", "", "getPlayerAmount", "()I", "appendPlatformData", "", "builder", "Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics$JsonObjectBuilder;", "appendServiceData", "JsonObjectBuilder", "MetricsBase", "core-plugin"})
public final class Metrics {
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private final MetricsBase metricsBase;

    public Metrics(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        File bStatsFolder = new File(this.plugin.getDataFolder().getParentFile(), "bStats");
        File configFile = new File(bStatsFolder, "config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)configFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration config = yamlConfiguration;
        if (!config.isSet("serverUuid")) {
            config.addDefault("enabled", (Object)true);
            config.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
            config.addDefault("logFailedRequests", (Object)false);
            config.addDefault("logSentData", (Object)false);
            config.addDefault("logResponseStatusText", (Object)false);
            config.options().copyDefaults(true);
            config.save(configFile);
        }
        String string = config.getString("serverUuid");
        Intrinsics.checkNotNull(string);
        String serverUUID = string;
        boolean logSentData = config.getBoolean("logSentData", false);
        boolean logResponseStatusText = config.getBoolean("logResponseStatusText", false);
        this.metricsBase = new MetricsBase("bukkit", serverUUID, this.plugin.getBStatsId(), arg_0 -> Metrics._init_$lambda$0(this, arg_0), arg_0 -> Metrics._init_$lambda$1(this, arg_0), arg_0 -> Metrics._init_$lambda$2(this, arg_0), () -> Metrics._init_$lambda$3(this), arg_0 -> Metrics._init_$lambda$4(this, arg_0), logSentData, logResponseStatusText);
    }

    private final void appendPlatformData(JsonObjectBuilder builder) {
        builder.appendField("playerAmount", this.getPlayerAmount());
        builder.appendField("onlineMode", Bukkit.getOnlineMode() ? 1 : 0);
        builder.appendField("bukkitVersion", Bukkit.getVersion());
        builder.appendField("bukkitName", Bukkit.getName());
        builder.appendField("javaVersion", System.getProperty("java.version"));
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private final void appendServiceData(JsonObjectBuilder builder) {
        builder.appendField("pluginVersion", this.plugin.getDescription().getVersion());
    }

    private final int getPlayerAmount() {
        return Bukkit.getOnlinePlayers().size();
    }

    private static final void _init_$lambda$0(Metrics this$0, JsonObjectBuilder builder) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(builder, "builder");
        this$0.appendPlatformData(builder);
    }

    private static final void _init_$lambda$1(Metrics this$0, JsonObjectBuilder builder) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(builder, "builder");
        this$0.appendServiceData(builder);
    }

    private static final void _init_$lambda$2(Metrics this$0, Runnable submitDataTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
        Plugin plugin = (Plugin)this$0.plugin;
        Runnable runnable = submitDataTask;
        Intrinsics.checkNotNull(runnable);
        bukkitScheduler.runTask(plugin, runnable);
    }

    private static final Boolean _init_$lambda$3(Metrics this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.plugin.isEnabled();
    }

    private static final void _init_$lambda$4(Metrics this$0, String message) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.plugin.getLogger().log(Level.INFO, message);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0018\u0010\b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0006\u0010\u0012\u001a\u00020\fR\u0016\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics$JsonObjectBuilder;", "", "()V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "hasAtLeastOneField", "", "appendField", "key", "", "object", "Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics$JsonObjectBuilder$JsonObject;", "value", "", "appendFieldUnescaped", "", "escapedValue", "build", "Companion", "JsonObject", "core-plugin"})
    @SourceDebugExtension(value={"SMAP\nMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metrics.kt\ncom/willfp/eco/internal/spigot/integrations/bstats/Metrics$JsonObjectBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
    public static final class JsonObjectBuilder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private StringBuilder builder = new StringBuilder();
        private boolean hasAtLeastOneField;

        public JsonObjectBuilder() {
            StringBuilder stringBuilder = this.builder;
            Intrinsics.checkNotNull(stringBuilder);
            stringBuilder.append("{");
        }

        @NotNull
        public final JsonObjectBuilder appendField(@Nullable String key, @Nullable String value) {
            if (value == null) {
                boolean bl = false;
                String string = "JSON value must not be null";
                throw new IllegalArgumentException(string.toString());
            }
            this.appendFieldUnescaped(key, "\"" + JsonObjectBuilder.Companion.escape(value) + "\"");
            return this;
        }

        @NotNull
        public final JsonObjectBuilder appendField(@Nullable String key, int value) {
            this.appendFieldUnescaped(key, String.valueOf(value));
            return this;
        }

        @NotNull
        public final JsonObjectBuilder appendField(@Nullable String key, @Nullable JsonObject object) {
            if (object == null) {
                boolean bl = false;
                String string = "JSON object must not be null";
                throw new IllegalArgumentException(string.toString());
            }
            this.appendFieldUnescaped(key, object.toString());
            return this;
        }

        private final void appendFieldUnescaped(String key, String escapedValue) {
            if (this.builder == null) {
                boolean bl = false;
                String string = "JSON has already been built";
                throw new IllegalStateException(string.toString());
            }
            if (key == null) {
                boolean bl = false;
                String string = "JSON key must not be null";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.hasAtLeastOneField) {
                StringBuilder stringBuilder = this.builder;
                Intrinsics.checkNotNull(stringBuilder);
                stringBuilder.append(",");
            }
            StringBuilder stringBuilder = this.builder;
            Intrinsics.checkNotNull(stringBuilder);
            stringBuilder.append("\"").append(JsonObjectBuilder.Companion.escape(key)).append("\":").append(escapedValue);
            this.hasAtLeastOneField = true;
        }

        @NotNull
        public final JsonObject build() {
            if (this.builder == null) {
                boolean bl = false;
                String string = "JSON has already been built";
                throw new IllegalStateException(string.toString());
            }
            StringBuilder stringBuilder = this.builder;
            Intrinsics.checkNotNull(stringBuilder);
            String string = stringBuilder.append("}").toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            JsonObject obj = new JsonObject(string);
            this.builder = null;
            return obj;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics$JsonObjectBuilder$Companion;", "", "()V", "escape", "", "value", "core-plugin"})
        public static final class Companion {
            private Companion() {
            }

            private final String escape(String value) {
                StringBuilder builder = new StringBuilder();
                int n = value.length();
                for (int i = 0; i < n; ++i) {
                    char element = value.charAt(i);
                    if (element == '\"') {
                        builder.append("\\\"");
                        continue;
                    }
                    if (element == '\\') {
                        builder.append("\\\\");
                        continue;
                    }
                    if (Intrinsics.compare(element, 15) <= 0) {
                        builder.append("\\u000").append(Integer.toHexString(element));
                        continue;
                    }
                    if (Intrinsics.compare(element, 31) <= 0) {
                        builder.append("\\u00").append(Integer.toHexString(element));
                        continue;
                    }
                    builder.append(element);
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics$JsonObjectBuilder$JsonObject;", "", "value", "", "(Ljava/lang/String;)V", "toString", "core-plugin"})
        public static final class JsonObject {
            @NotNull
            private final String value;

            public JsonObject(@NotNull String value) {
                Intrinsics.checkNotNullParameter(value, "value");
                this.value = value;
            }

            @NotNull
            public String toString() {
                return this.value;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aBu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics$MetricsBase;", "", "platform", "", "serverUuid", "serviceId", "", "appendPlatformDataConsumer", "Ljava/util/function/Consumer;", "Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics$JsonObjectBuilder;", "appendServiceDataConsumer", "submitTaskConsumer", "Ljava/lang/Runnable;", "checkServiceEnabledSupplier", "Ljava/util/function/Supplier;", "", "infoLogger", "logSentData", "logResponseStatusText", "(Ljava/lang/String;Ljava/lang/String;ILjava/util/function/Consumer;Ljava/util/function/Consumer;Ljava/util/function/Consumer;Ljava/util/function/Supplier;Ljava/util/function/Consumer;ZZ)V", "sendData", "", "data", "Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics$JsonObjectBuilder$JsonObject;", "startSubmitting", "submitData", "Companion", "core-plugin"})
    @SourceDebugExtension(value={"SMAP\nMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metrics.kt\ncom/willfp/eco/internal/spigot/integrations/bstats/Metrics$MetricsBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
    public static final class MetricsBase {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String platform;
        @NotNull
        private final String serverUuid;
        private final int serviceId;
        @NotNull
        private final Consumer<JsonObjectBuilder> appendPlatformDataConsumer;
        @NotNull
        private final Consumer<JsonObjectBuilder> appendServiceDataConsumer;
        @Nullable
        private final Consumer<Runnable> submitTaskConsumer;
        @NotNull
        private final Supplier<Boolean> checkServiceEnabledSupplier;
        @NotNull
        private final Consumer<String> infoLogger;
        private final boolean logSentData;
        private final boolean logResponseStatusText;
        @NotNull
        public static final String METRICS_VERSION = "2.2.1";
        private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, MetricsBase::scheduler$lambda$5);
        @NotNull
        private static final String REPORT_URL = "https://bStats.org/api/v2/data/%s";

        public MetricsBase(@NotNull String platform, @NotNull String serverUuid, int serviceId, @NotNull Consumer<JsonObjectBuilder> appendPlatformDataConsumer, @NotNull Consumer<JsonObjectBuilder> appendServiceDataConsumer, @Nullable Consumer<Runnable> submitTaskConsumer, @NotNull Supplier<Boolean> checkServiceEnabledSupplier, @NotNull Consumer<String> infoLogger, boolean logSentData, boolean logResponseStatusText) {
            Intrinsics.checkNotNullParameter(platform, "platform");
            Intrinsics.checkNotNullParameter(serverUuid, "serverUuid");
            Intrinsics.checkNotNullParameter(appendPlatformDataConsumer, "appendPlatformDataConsumer");
            Intrinsics.checkNotNullParameter(appendServiceDataConsumer, "appendServiceDataConsumer");
            Intrinsics.checkNotNullParameter(checkServiceEnabledSupplier, "checkServiceEnabledSupplier");
            Intrinsics.checkNotNullParameter(infoLogger, "infoLogger");
            this.platform = platform;
            this.serverUuid = serverUuid;
            this.serviceId = serviceId;
            this.appendPlatformDataConsumer = appendPlatformDataConsumer;
            this.appendServiceDataConsumer = appendServiceDataConsumer;
            this.submitTaskConsumer = submitTaskConsumer;
            this.checkServiceEnabledSupplier = checkServiceEnabledSupplier;
            this.infoLogger = infoLogger;
            this.logSentData = logSentData;
            this.logResponseStatusText = logResponseStatusText;
            this.startSubmitting();
        }

        private final void startSubmitting() {
            Runnable submitTask = () -> MetricsBase.startSubmitting$lambda$1(this);
            long initialDelay = (long)((double)60000 * ((double)3 + Math.random() * (double)3));
            long secondDelay = (long)((double)60000 * (Math.random() * (double)30));
            MetricsKt.access$runIgnoring(new Function0<Unit>(submitTask, initialDelay, secondDelay){
                final /* synthetic */ Runnable $submitTask;
                final /* synthetic */ long $initialDelay;
                final /* synthetic */ long $secondDelay;
                {
                    this.$submitTask = $submitTask;
                    this.$initialDelay = $initialDelay;
                    this.$secondDelay = $secondDelay;
                    super(0);
                }

                public final void invoke() {
                    MetricsBase.access$getScheduler$cp().schedule(this.$submitTask, this.$initialDelay, TimeUnit.MILLISECONDS);
                    MetricsBase.access$getScheduler$cp().scheduleAtFixedRate(this.$submitTask, this.$initialDelay + this.$secondDelay, 1800000L, TimeUnit.MILLISECONDS);
                }
            });
        }

        private final void submitData() {
            JsonObjectBuilder baseJsonBuilder = new JsonObjectBuilder();
            this.appendPlatformDataConsumer.accept(baseJsonBuilder);
            JsonObjectBuilder serviceJsonBuilder = new JsonObjectBuilder();
            this.appendServiceDataConsumer.accept(serviceJsonBuilder);
            serviceJsonBuilder.appendField("id", this.serviceId);
            baseJsonBuilder.appendField("service", serviceJsonBuilder.build());
            baseJsonBuilder.appendField("serverUUID", this.serverUuid);
            baseJsonBuilder.appendField("metricsVersion", METRICS_VERSION);
            JsonObjectBuilder.JsonObject data2 = baseJsonBuilder.build();
            MetricsKt.access$runIgnoring(new Function0<Unit>(this, data2){
                final /* synthetic */ MetricsBase this$0;
                final /* synthetic */ JsonObjectBuilder.JsonObject $data;
                {
                    this.this$0 = $receiver;
                    this.$data = $data;
                    super(0);
                }

                public final void invoke() {
                    MetricsBase.access$getScheduler$cp().execute(() -> submitData.1.invoke$lambda$0(this.this$0, this.$data));
                }

                private static final void invoke$lambda$0(MetricsBase this$0, JsonObjectBuilder.JsonObject $data) {
                    Intrinsics.checkNotNullParameter(this$0, "this$0");
                    Intrinsics.checkNotNullParameter($data, "$data");
                    MetricsKt.access$runIgnoring(new Function0<Unit>(this$0, $data){
                        final /* synthetic */ MetricsBase this$0;
                        final /* synthetic */ JsonObjectBuilder.JsonObject $data;
                        {
                            this.this$0 = $receiver;
                            this.$data = $data;
                            super(0);
                        }

                        public final void invoke() {
                            MetricsBase.access$sendData(this.this$0, this.$data);
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendData(JsonObjectBuilder.JsonObject data2) throws Exception {
            Object object;
            if (this.logSentData) {
                this.infoLogger.accept("Sent bStats metrics data: " + data2);
            }
            String string = REPORT_URL;
            Object object2 = new Object[]{this.platform};
            String string2 = String.format(string, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            String url2 = string2;
            URLConnection uRLConnection = new URL(url2).openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
            HttpsURLConnection connection = (HttpsURLConnection)uRLConnection;
            byte[] compressedData = MetricsBase.Companion.compress(data2.toString());
            connection.setRequestMethod("POST");
            connection.addRequestProperty("Accept", "application/json");
            connection.addRequestProperty("Connection", "close");
            connection.addRequestProperty("Content-Encoding", "gzip");
            Intrinsics.checkNotNull(compressedData);
            connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Metrics-Service/1");
            connection.setDoOutput(true);
            object2 = new DataOutputStream(connection.getOutputStream());
            Object object3 = null;
            try {
                DataOutputStream outputStream = (DataOutputStream)object2;
                boolean bl = false;
                outputStream.write(compressedData);
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            StringBuilder builder = new StringBuilder();
            object3 = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            object = null;
            try {
                BufferedReader bufferedReader = (BufferedReader)object3;
                boolean bl = false;
                String line = null;
                while (true) {
                    String string3;
                    String it = string3 = bufferedReader.readLine();
                    boolean bl2 = false;
                    line = it;
                    if (string3 == null) break;
                    builder.append(line);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)object);
            }
            if (this.logResponseStatusText) {
                this.infoLogger.accept("Sent data to bStats and received response: " + builder);
            }
        }

        private static final void startSubmitting$lambda$1$lambda$0(MetricsBase this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.submitData();
        }

        private static final void startSubmitting$lambda$1(MetricsBase this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            if (!this$0.checkServiceEnabledSupplier.get().booleanValue()) {
                scheduler.shutdown();
                return;
            }
            if (this$0.submitTaskConsumer != null) {
                this$0.submitTaskConsumer.accept(() -> MetricsBase.startSubmitting$lambda$1$lambda$0(this$0));
            } else {
                this$0.submitData();
            }
        }

        private static final Thread scheduler$lambda$5(Runnable task) {
            return new Thread(task, "bStats-Metrics");
        }

        public static final /* synthetic */ ScheduledExecutorService access$getScheduler$cp() {
            return scheduler;
        }

        public static final /* synthetic */ void access$sendData(MetricsBase $this, JsonObjectBuilder.JsonObject data2) {
            $this.sendData(data2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/bstats/Metrics$MetricsBase$Companion;", "", "()V", "METRICS_VERSION", "", "REPORT_URL", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "compress", "", "str", "core-plugin"})
        @SourceDebugExtension(value={"SMAP\nMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metrics.kt\ncom/willfp/eco/internal/spigot/integrations/bstats/Metrics$MetricsBase$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final byte[] compress(String str) {
                if (str == null) {
                    return null;
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                Closeable closeable = new GZIPOutputStream(outputStream);
                Throwable throwable = null;
                try {
                    GZIPOutputStream gzip = (GZIPOutputStream)closeable;
                    boolean bl = false;
                    String string = str;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                    gzip.write(byArray);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                return outputStream.toByteArray();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

