/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.price;

import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContextSupplier;
import com.willfp.eco.core.price.Price;
import com.willfp.eco.core.price.PriceFactory;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.entity.Player;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/price/PriceFactoryPlayerPoints;", "Lcom/willfp/eco/core/price/PriceFactory;", "()V", "create", "Lcom/willfp/eco/core/price/Price;", "baseContext", "Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;", "function", "Lcom/willfp/eco/core/placeholder/context/PlaceholderContextSupplier;", "", "getNames", "", "", "PricePlayerPoints", "core-plugin"})
public final class PriceFactoryPlayerPoints
implements PriceFactory {
    @Override
    @NotNull
    public List<String> getNames() {
        String[] stringArray = new String[]{"player_points", "p_points"};
        return CollectionsKt.listOf(stringArray);
    }

    @Override
    @NotNull
    public Price create(@NotNull PlaceholderContext baseContext, @NotNull PlaceholderContextSupplier<Double> function) {
        Intrinsics.checkNotNullParameter(baseContext, "baseContext");
        Intrinsics.checkNotNullParameter(function, "function");
        return new PricePlayerPoints(baseContext, (Function1<? super PlaceholderContext, Integer>)new Function1<PlaceholderContext, Integer>(function){
            final /* synthetic */ PlaceholderContextSupplier<Double> $function;
            {
                this.$function = $function;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull PlaceholderContext it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Double d = this.$function.get(it);
                Intrinsics.checkNotNullExpressionValue(d, "get(...)");
                return MathKt.roundToInt(((Number)d).doubleValue());
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/price/PriceFactoryPlayerPoints$PricePlayerPoints;", "Lcom/willfp/eco/core/price/Price;", "baseContext", "Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;", "function", "Lkotlin/Function1;", "", "(Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;Lkotlin/jvm/functions/Function1;)V", "api", "Lorg/black_ixx/playerpoints/PlayerPointsAPI;", "kotlin.jvm.PlatformType", "multipliers", "", "Ljava/util/UUID;", "", "canAfford", "", "player", "Lorg/bukkit/entity/Player;", "multiplier", "getMultiplier", "getValue", "giveTo", "", "pay", "setMultiplier", "core-plugin"})
    private static final class PricePlayerPoints
    implements Price {
        @NotNull
        private final PlaceholderContext baseContext;
        @NotNull
        private final Function1<PlaceholderContext, Integer> function;
        private final PlayerPointsAPI api;
        @NotNull
        private final Map<UUID, Double> multipliers;

        public PricePlayerPoints(@NotNull PlaceholderContext baseContext, @NotNull Function1<? super PlaceholderContext, Integer> function) {
            Intrinsics.checkNotNullParameter(baseContext, "baseContext");
            Intrinsics.checkNotNullParameter(function, "function");
            this.baseContext = baseContext;
            this.function = function;
            this.api = PlayerPoints.getInstance().getAPI();
            this.multipliers = new LinkedHashMap();
        }

        @Override
        public boolean canAfford(@NotNull Player player, double multiplier) {
            Intrinsics.checkNotNullParameter(player, "player");
            return (double)this.api.look(player.getUniqueId()) >= this.getValue(player, multiplier);
        }

        @Override
        public void pay(@NotNull Player player, double multiplier) {
            Intrinsics.checkNotNullParameter(player, "player");
            this.api.take(player.getUniqueId(), MathKt.roundToInt(this.getValue(player, multiplier)));
        }

        @Override
        public void giveTo(@NotNull Player player, double multiplier) {
            Intrinsics.checkNotNullParameter(player, "player");
            this.api.give(player.getUniqueId(), MathKt.roundToInt(this.getValue(player, multiplier)));
        }

        @Override
        public double getValue(@NotNull Player player, double multiplier) {
            Intrinsics.checkNotNullParameter(player, "player");
            PlaceholderContext placeholderContext = this.baseContext.copyWithPlayer(player);
            Intrinsics.checkNotNullExpressionValue(placeholderContext, "copyWithPlayer(...)");
            return ((Number)this.function.invoke(placeholderContext)).doubleValue() * this.getMultiplier(player) * multiplier;
        }

        @Override
        public double getMultiplier(@NotNull Player player) {
            Intrinsics.checkNotNullParameter(player, "player");
            Double d = this.multipliers.get(player.getUniqueId());
            return d != null ? d : 1.0;
        }

        @Override
        public void setMultiplier(@NotNull Player player, double multiplier) {
            Intrinsics.checkNotNullParameter(player, "player");
            Map<UUID, Double> map2 = this.multipliers;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            UUID uUID2 = uUID;
            Double d = multiplier;
            map2.put(uUID2, d);
        }
    }
}

