/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node;

import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.Token;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.TokenType;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.TextNode;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ElementNode {
    @Nullable
    private final ElementNode parent;
    @Nullable
    private final Token token;
    private final String sourceMessage;
    private final List<ElementNode> children = new ArrayList<ElementNode>();

    ElementNode(@Nullable ElementNode parent, @Nullable Token token2, @NotNull String sourceMessage) {
        this.parent = parent;
        this.token = token2;
        this.sourceMessage = sourceMessage;
    }

    @Nullable
    public ElementNode parent() {
        return this.parent;
    }

    @Nullable
    public Token token() {
        return this.token;
    }

    @NotNull
    public String sourceMessage() {
        return this.sourceMessage;
    }

    public List<ElementNode> children() {
        return this.children;
    }

    public void addChild(ElementNode childNode) {
        int last2 = this.children.size() - 1;
        if (!(childNode instanceof TextNode) || this.children.isEmpty() || !(this.children.get(last2) instanceof TextNode)) {
            this.children.add(childNode);
        } else {
            TextNode lastNode = (TextNode)this.children.remove(last2);
            if (lastNode.token().endIndex() == childNode.token().startIndex()) {
                Token replace2 = new Token(lastNode.token().startIndex(), childNode.token().endIndex(), TokenType.TEXT);
                this.children.add(new TextNode(this, replace2, lastNode.sourceMessage()));
            } else {
                this.children.add(lastNode);
                this.children.add(childNode);
            }
        }
    }

    @NotNull
    public StringBuilder buildToString(@NotNull StringBuilder sb, int indent) {
        char[] in = this.ident(indent);
        sb.append(in).append("Node {\n");
        for (ElementNode child : this.children) {
            child.buildToString(sb, indent + 1);
        }
        sb.append(in).append("}\n");
        return sb;
    }

    char @NotNull [] ident(int indent) {
        char[] c = new char[indent * 2];
        Arrays.fill(c, ' ');
        return c;
    }

    public String toString() {
        return this.buildToString(new StringBuilder(), 0).toString();
    }
}

