/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.inbuild;

import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.Transformation;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.examination.ExaminableProperty;

public final class ColorTransformation
extends Transformation {
    private static final Map<String, TextColor> COLOR_ALIASES = new HashMap<String, TextColor>();
    private final TextColor color;

    private static boolean isColorOrAbbreviation(String name) {
        return name.equals("color") || name.equals("colour") || name.equals("c");
    }

    public static boolean canParse(String name) {
        return ColorTransformation.isColorOrAbbreviation(name) || TextColor.fromHexString(name) != null || NamedTextColor.NAMES.value(name) != null || COLOR_ALIASES.containsKey(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColorTransformation create(String name, List<TagPart> args2) {
        String colorName;
        if (ColorTransformation.isColorOrAbbreviation(name)) {
            if (args2.size() != 1) throw new ParsingException("Expected to find a color parameter, but found " + args2, args2);
            colorName = args2.get(0).value().toLowerCase(Locale.ROOT);
        } else {
            colorName = name;
        }
        TextColor color = COLOR_ALIASES.containsKey(colorName) ? COLOR_ALIASES.get(colorName) : (colorName.charAt(0) == '#' ? TextColor.fromHexString(colorName) : (TextColor)NamedTextColor.NAMES.value(colorName));
        if (color != null) return new ColorTransformation(color);
        throw new ParsingException("Don't know how to turn '" + name + "' into a color", args2);
    }

    private ColorTransformation(TextColor color) {
        this.color = color;
    }

    @Override
    public Component apply() {
        return Component.empty().color(this.color);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("color", this.color));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ColorTransformation that = (ColorTransformation)other;
        return Objects.equals(this.color, that.color);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.color);
    }

    static {
        COLOR_ALIASES.put("dark_grey", NamedTextColor.DARK_GRAY);
        COLOR_ALIASES.put("grey", NamedTextColor.GRAY);
    }
}

